import { Dict } from '../../../../types';
import UserInfo, { BasicUserInfo } from '../../../models/user';

export type TSearchLinkArray = {link: string; linkText: string}[];

export enum SEARCH_ID_TYPE {
    ORGANIZATION_ID = 'organization_id',
    WALLET_LIMIT_ID = 'wallet_account_id',
    PARENT_ID = 'parent_id', // only for redirect
}

export enum SEARCH_NAME_TYPE {
    ORGANIZATION_NAME = 'organization_name'
}

export interface ISearchWalletsResults {
    organizations: Dict<IWalletOrganization>;
    walletLimits: IWalletLimit[];
    walletAccounts: Dict<IWalletAccounts[]>;
}

export interface IWalletOrganization {
    name: string;
    details: {
        soft_limit: number;
        comment: string;
        company: string;
        hard_limit: number;
        expenditure: number;
        next_refresh: number;
        enable_toll_roads: boolean;
        balance_info?: {
            overdraft: number;
        };
    };
    parent?: IWalletOrganization;
    enable_toll_road_pay: boolean;
    balance: number;
    spent: number;
    offers_filter: string;
    soft_limit: number;
    comment: string;
    data_type: string;
    id: number;
    is_actual: boolean;
    type_name: string;
    disabled: boolean;
    type: string;
    is_active: boolean;
    offers_filter_name: string;
    hard_limit: number;
    version: number;
    selectable: boolean;
}

export interface IWalletLimit {
    organization_creator?: UserInfo[];
    name: string;
    soft_limit: number;
    hard_limit: number;
    type: string;
    meta: {
        short_description: string;
        limited_policy: boolean;
        max_links: number;
        parent_id: number;
        time_restrictions: {
            time_zone: number;
            restrictions: any[];
        };
        offers_filter: string;
        refresh_interval: number;
        selectable: boolean;
        hr_name: string;
        refresh_policy: string;
        is_personal: boolean;
        insurance_types: any[];
        priority: number;
        enable_toll_roads: boolean;
    };
    id: number;
}

export interface IWalletAccounts {
    data: {
        name: string;
        details: {
            soft_limit: number;
            comment: string;
            company: string;
            hard_limit: number;
            expenditure: number;
            next_refresh: number;
            enable_toll_roads: boolean;
        };
        balance: number;
        parent: {
            id: number;
            is_active: boolean;
            balance: number;
        };
        enable_toll_road_pay: boolean;
        spent: number;
        offers_filter: string;
        soft_limit: number;
        comment: string;
        data_type: string;
        id: number;
        is_actual: boolean;
        type_name: string;
        disabled: boolean;
        type: string;
        is_active: boolean;
        offers_filter_name: string;
        hard_limit: number;
        version: number;
        selectable: boolean;
    };
    users: BasicUserInfo[];
}

export interface IBalanceHistoryData {
    timestamp: number;
    company: string;
    limit: number;
    limitDiff: number;
}

export interface IOverdraftHistoryData {
    timestamp: number;
    company: string;
    overdraft: number;
    overdraftDiff: number;
}

export interface IUserLinksData {
    action: string;
    timestamp: number;
    userId: string;
    authorUserId: string;
}

export const VIRTUALLIST_TABLE_HEIGHT = 500;
