import { Dict } from '../../../types';
import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export const REQUESTS: Dict<string> = {
    /* SearchWallets */
    GET_ACCOUNTS: 'GET_ACCOUNTS',
    GET_WALLETS: 'GET_WALLETS',
    GET_WALLETS_HISTORY: 'GET_WALLETS_HISTORY',
    ACTIVATE_ACCOUNT: 'ACTIVATE_ACCOUNT',
    GET_BALANCE: 'GET_BALANCE',
    GET_USER_LINKS: 'GET_USER_LINKS',
    GET_B2B_RIDES: 'GET_B2B_RIDES',
    B2B_OVERDRAFT: 'B2B_OVERDRAFT',
};

const BIG_LIMIT = 99999;

export const B2B_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_ACCOUNTS]: {
        api: 'billing/accounts',
        cgiObj: {
            account_name: null,
            numdoc: BIG_LIMIT,
            account_id: null,
        },
    },
    [REQUESTS.GET_WALLETS]: {
        api: 'billing/accounts/descriptions',
        cgiObj: {
            account_name: null, //accepts cyrillic
            parent_id: null, // NOT id of wallet
            access_tags: null,
        },
    },
    [REQUESTS.GET_WALLETS_HISTORY]: {
        api: 'billing/accounts/descriptions/history',
        cgiObj: {
            name: null, // имя кошелька
            id: null, // идентификатор кошелька
            since: null, // timestamp начала выборки
            history_marker: null, // фильтр по полю history_comment
            limit: null, // количество элементов в выборке
            offset: null, // сдвиг выборки для плагинации
        },
    },
    [REQUESTS.ACTIVATE_ACCOUNT]: {
        method: REQUEST_METHOD.POST,
        api: 'billing/accounts/activate',
    },
    [REQUESTS.GET_B2B_RIDES]: {
        api: 'sessions/history',
        cgiObj: {
            user_id: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_BALANCE]: {
        api: 'billing/accounts/history',
        cgiObj: {
            account_id: null,
            history_marker: 'b2b_balance_refresh',
            limit: BIG_LIMIT,
        },
    },
    [REQUESTS.GET_USER_LINKS]: {
        api: 'billing/accounts/history',
        cgiObj: {
            account_id: null,
            limit: BIG_LIMIT,
        },
    },
    [REQUESTS.B2B_OVERDRAFT]: {
        api: 'billing/accounts/overdraft',
        method: REQUEST_METHOD.POST,
    },
};
