import * as React from 'react';

import { Button } from '../../../../ui/Button';
import DatePicker from '../../../../ui/DatePicker';
import { SinceUntilSearchInitialSince, SinceUntilSearchInitialUntil } from './constants';
import * as styles from './index.css';

interface ISinceUntilSearchProps {
    initialSince?: number;
    initialUntil?: number;
    onSearch: ({ since, until }) => unknown;
    className?: string;
    isSearching?: boolean;
    showSince?: boolean;
    showUntil?: boolean;
}

export const SinceUntilSearch = (props: ISinceUntilSearchProps) => {
    const {
        initialSince = SinceUntilSearchInitialSince,
        initialUntil = SinceUntilSearchInitialUntil,
        onSearch,
        className,
        isSearching,
        showSince = true,
        showUntil = true,
    } = props;
    const [since, setSince] = React.useState(initialSince);
    const [until, setUntil] = React.useState(initialUntil);

    return <div className={`${styles.sinceUntilSearch} ${className}`}>
        {showSince && <DatePicker className={styles.input}
                                  value={since}
                                  placeholder={'since'}
                                  onChange={setSince.bind(null)}/>}
        {showUntil && <DatePicker className={styles.input}
                                  value={until}
                                  placeholder={'until'}
                                  onChange={setUntil.bind(null)}/>}
        <Button isLoading={isSearching}
                className={styles.input}
                onClick={onSearch.bind(null, { since, until })}>
            Поиск
        </Button>
    </div>;
};
