import * as React from 'react';

import { EMPTY_DATA } from '../../../../constants';
import * as styles from './index.css';

interface IWalletActiveIndicatorProps {
    isActive: boolean | undefined;
    className?: string;
}

export const WalletActiveIndicator = (props: IWalletActiveIndicatorProps) => {
    const { isActive, className } = props;

    return typeof isActive === 'boolean'
        ? <span title={isActive.toString()}
                className={`${styles.isActual} ${styles[`isActual-${isActive.toString()}`]} ${className ? className : ''}`}/>
        : <span>{EMPTY_DATA}</span>;
};
