import React from 'react';
import { connect } from 'react-redux';

import { Dict } from '../../../../types';
import { Button, ButtonTypes, CancelButton } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import * as coreStyle from '../../../ui/index.css';
import Select from '../../../ui/Select';
import { fetchConstants } from '../../../utils/fetchConstants';
import { Request2 } from '../../../utils/request';
import style from './index.css';
import { CAR_REQUESTS, REQUESTS } from './request';

interface IAnyCommandProps {
    carInfo: Dict<any>;
    questionDetails: any;
}

export const AnyCommand = React.memo((props: IAnyCommandProps) => {
    const [modalIsOpen, showModal] = React.useState(false);

    return <div className={`${style.component}`}>
        {
            modalIsOpen
            && <AnyCommandModalContainer onClose={showModal.bind(null, false)}
                                         carInfo={props.carInfo}
                                         questionDetails={props.questionDetails}/>
        }
        <Button colorType={ButtonTypes.negative} onClick={showModal.bind(null, true)}>ТЕЛЕМАТИКА</Button>
    </div>;
});

class AnyCommandModal extends React.Component<any, any> {
    state = {
        telematics_commands: [],
        isLoading: true,
        error: null,
        command: '',
        isWorking: false,
    };
    request = new Request2({ requestConfigs: CAR_REQUESTS });

    componentWillUnmount() {
        this.request.abort();
    }

    getData() {
        this.setState({
            isLoading: true,
        }, () => {
            this.props.getTelematicsCommands
                .then(response => {
                    this.setState({
                        isLoading: false,
                        telematics_commands: response?.telematics_commands?.map(el => ({ text: el, value: el })) || [],
                    });
                })
                .catch(error => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });
    }

    componentDidMount() {
        this.getData();
    }

    onSelect(command) {
        this.setState({ command });
    }

    command() {
        this.setState({
            isWorking: true,
        }, () => {
            this.request.exec(REQUESTS.CAR_CONTROL, {
                queryParams: {
                    car_id: this.props?.carInfo?.id,
                    command: this.state.command,
                },
            })
                .then(() => {
                    this.setState({
                        isWorking: false,
                    });
                    this.props.onClose();
                })
                .catch((error) => {
                    this.setState({
                        isWorking: false,
                        error,
                    });
                });
        });
    }

    render() {
        return <Window onClose={this.props.onClose.bind(this)}
                       error={this.state.error}
                       title={'Выполнить команду телематики?'}>
            <div>{this.props.questionDetails}</div>
            <Select options={this.state.telematics_commands}
                    onSelect={this.onSelect.bind(this)}
                    isLoading={this.state.isLoading}
                    placeholder={'команда'}/>
            <div className={coreStyle.button_container}>
                <CancelButton onClick={this.props.onClose.bind(this)}/>
                <Button onClick={this.command.bind(this)}
                        isLoading={this.state.isLoading || this.state.isWorking}
                        disabled={!this.state.command}>
                    Отправить
                </Button>
            </div>
        </Window>;
    }
}

export const mapStateToProps = () => {
    return {};
};

export function mapDispatchToProps(dispatch: any) {
    return { getTelematicsCommands: fetchConstants(['telematics_commands'], dispatch) };
}

const AnyCommandModalContainer = connect(mapStateToProps, mapDispatchToProps)(AnyCommandModal);
