import moment from 'moment';
import * as React from 'react';

import { ISearchControls, WithSearchControls } from '../../../../decorators/SearchControls';
import { Request2 } from '../../../utils/request';
import AcceptancePhotos, { IAcceptancePhotos } from '../../AcceptancePhotos/component';
import Spin from '../../Spin';
import { CAR_REQUESTS as requestConfigs, REQUESTS } from '../request';

interface ICarAcceptancePhotosProps extends ISearchControls {
    carId: string;
}

interface ICarAcceptancePhotosState {
    data?: IAcceptancePhotos;
    isLoading: boolean;
}

const THREE_DAYS = 3;

@WithSearchControls({
    since: moment().subtract(THREE_DAYS, 'days'),
    until: moment(),
})
export default class CarAcceptancePhotos extends React.Component<ICarAcceptancePhotosProps, ICarAcceptancePhotosState> {
    state: ICarAcceptancePhotosState = {
        isLoading: false,
    };
    request = new Request2({ requestConfigs });

    componentDidMount() {
        this.getData();
    }

    componentDidUpdate(prevProps: Readonly<ICarAcceptancePhotosProps>): void {
        if (this.props.carId !== prevProps.carId || this.props.since !== prevProps.since
            || this.props.until !== prevProps.until) {
            this.getData();
        }
    }

    getData() {
        this.request.abort();
        this.setState({
            isLoading: true,
        }, () => {
            const since: number = this.props.since;
            const until: number = this.props.until;
            const car_id = this.props.carId;

            this.request.exec(REQUESTS.GET_ACCEPTANCE_PHOTOS, { queryParams: { since, until, car_id } })
                .then(response => {
                    this.setState({
                        data: response || {},
                        isLoading: false,
                    });
                });
        });
    }

    componentWillUnmount() {
        this.request.abort();
    }

    render() {
        return this.state.isLoading ? <Spin/> :
            <AcceptancePhotos data={this.state.data}
                              showSessionLink/>;
    }
}
