import React from 'react';
import { connect } from 'react-redux';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { Link } from '../../../ui/Link';
import { getRawSetting2 } from '../../../utils/getRawSetting';
import { dedicated_fleet_links } from '../../InterfaceAdminConfig/adminConfigKeys';
import * as style from '../index.css';

const DedicatedFleetBadge = React.memo((props: { dedicatedFleetTag: any; dedicatedFleetLinks?: any[] }) => {
    const GVarsItem = props.dedicatedFleetLinks?.find(el => el.parent_id == props.dedicatedFleetTag.parent_id);
    const link = GVarsItem?.link;
    const name = GVarsItem?.company_name;

    const additionalBadgeStyle = link ? style.full_table : style.short_table;

    return <div className={`${style.dedicated_fleet_badge} ${additionalBadgeStyle}`}>
        <div className={style.fleet_icon}/>

        <div className={style.fleet_mark}>
            Машина из выделенного парка
        </div>

        <div className={style.fleet_name}>
            {name ?? props.dedicatedFleetTag.comment}
        </div>

        {link
            ? <Link className={style.fleet_link} href={link} target={'_blank'}>
                Условия использования
                <span className={style.chevron}/>
            </Link>
            : null
        }
    </div>;
});

export const mapStateToProps = (store) => {
    const key = `${GVARS_INTERFACE_ADMIN_PREFIX}.${dedicated_fleet_links}`;

    return {
        dedicatedFleetLinks: getRawSetting2(store, key),
    };
};

export default connect(mapStateToProps)(DedicatedFleetBadge);
