import React from "react";

import { CarInfoHandler } from "../../../models/car";
import { Button } from "../../../ui/Button";
import { Link } from "../../../ui/Link";
import style from '../index.css';

interface ICompensationButton {
    car: Record<string, any>;
}

const FORM_URL = 'https://forms.yandex-team.ru/surveys/27094';

export const CompensationButton = React.memo((props: ICompensationButton) => {
    const { car } = props;
    const CIH = CarInfoHandler;

    const stateNumber = CIH.getNumber.call(car);
    const vin = CIH.getVin.call(car);
    const model = CIH.getModelFullName.call(car);

    const href = `${FORM_URL}?state_number=${stateNumber}&vin=${vin}&model=${model}`;

    return <Link href={href} target="_blank" className={style.compensation}>
        <Button>
        Возмещение
        </Button>
    </Link>;
});
