import * as React from 'react';

import { CAR_ACTIONS } from '../../../models/car';
import { QuickActionButton } from '../../../ui/QuickActionButton';
import { Request2 } from '../../../utils/request';
import { buttonLocationDetails, buttonNameDetails } from '../../../utils/sendLogs/eventTypes/buttonDetails';
import style from '../index.css';
import { CAR_REQUESTS as requestConfigs, REQUESTS } from '../request';

interface ILeafControlsProps {
    car_id: string;
}

interface ILeafControlsState {}

export default class LeafControls extends React.Component<ILeafControlsProps, ILeafControlsState> {
    request = new Request2({ requestConfigs });

    runCommand(action) {
        const { car_id } = this.props;

        return this.request.exec(REQUESTS.CAR_ACTION, {
            body: {
                car_id,
                action,
            },
        });
    }

    render() {
        return <div className={style.leaf_container}>
            <QuickActionButton question={<div>Открыть лючок зарядки?</div>}
                               button={{
                                   children: 'Открыть лючок',
                                   basic: true,
                               }}
                               showConfirm
                               accept={this.runCommand.bind(this, CAR_ACTIONS.UNLOCK_CHARGE_PORT)}
                               ytLog={{
                                   button_name: buttonNameDetails.UNLOCK_CHARGE_PORT,
                                   location: buttonLocationDetails.CAR_CARD,
                               }}/>

            <QuickActionButton question={<div>Открыть коннектор зарядки?</div>}
                               button={{
                                   children: 'Открыть коннектор',
                                   basic: true,
                               }}
                               showConfirm
                               accept={this.runCommand.bind(this, CAR_ACTIONS.UNLOCK_CHARGE_CONNECTOR)}
                               ytLog={{
                                   button_name: buttonNameDetails.UNLOCK_CHARGE_CONNECTOR,
                                   location: buttonLocationDetails.CAR_CARD,
                               }}/>
        </div>;
    }
}
