import React from 'react';

import { Link } from '../../../ui/Link';
import * as styleTable from '../../../ui/Table/index.css';
import { CarGarageListItem } from './CarGarageListItem';
import * as style from './index.css';
import { IAttachmentItem } from './types';

interface IAttachmentItemProps {
    list: IAttachmentItem;
    onClick?: () => void;
}

export const AttachmentItem = (props: IAttachmentItemProps) => {
    const { list = {} as IAttachmentItem, onClick } = props;
    const renderData = Object.entries(list.data ?? {});
    const isVegaType = list.type === 'Вега';

    return <div>
        <div className={style.attach_info}>
            <div>
                <div className={isVegaType ? style.vega : ''}>{list.type}</div>
                <div className={`${style.attach_id} ${isVegaType ? style.vega : ''}`}>
                    {list.id}
                </div>
            </div>
            {onClick
                ? <Link className={style.attach_link}
                        onClick={onClick.bind(null, list.id)}>
                    Демонтировать
                </Link>
                : null
            }
        </div>

        <table className={`${styleTable.table} ${style.table}`}>
            <tbody>
                {renderData?.length
                    ? renderData.map((item: [string, string], index) => {
                        return <CarGarageListItem index={index} item={item} key={index}/>;
                    })
                    : null
                }
            </tbody>
        </table>
    </div>;
};
