import React from 'react';

import { Link } from '../../../ui/Link';
import * as style from './index.css';

interface ICarGarageListItemProps {
    index: number;
    item: [string, string];
}

interface ICarGarageListItemState {
}

export class CarGarageListItem extends React.Component<ICarGarageListItemProps, ICarGarageListItemState> {
    render() {
        const { index, item } = this.props;

        return <tr key={index} className={style.table_row}>
            <td>{index + 1}</td>
            <td>{item[0]}</td>
            <td>{/^http/i.test(item[1])
                ? <Link target={'_blank'} href={item[1]}>{item[1]}</Link>
                : JSON.stringify(item[1])}</td>
        </tr>;
    }
}
