import React from 'react';

import { ONE_SECOND } from '../../../constants';
import FormatDate from '../../../ui/FormatDate';
import { Request2 } from '../../../utils/request';
import { SimpleError } from '../../SimpleError';
import Spin from '../../Spin';
import { CAR_REQUESTS as requestConfigs, REQUESTS } from '../request';
import * as style from './index.css';

interface ILastTyreProps {
    carId: string;
}

interface ILastTyreState {
    date: string;
    isLoading: boolean;
    error: Error | null;
}

export default class LastTyre extends React.Component<ILastTyreProps, ILastTyreState> {
    state = {
        date: '',
        isLoading: false,
        error: null,
    };
    request = new Request2({ requestConfigs });

    componentDidMount(): void {
        this.getData();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    getData() {
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_MAJOR_LAST_TYRE, { queryParams: { ids: [this.props.carId] } })
                .then(response => {
                    this.setState({
                        isLoading: false,
                        date: response.result && response.result[this.props.carId] || '',
                    });
                })
                .catch(error => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });
    }

    render() {
        const { isLoading, error, date } = this.state;

        return <div className={style.tyre}>
            {isLoading
                ? <Spin/>
                : error
                    ? <SimpleError error={error}/>
                    : <div><strong>Шиномонтаж: </strong><FormatDate value={+date * ONE_SECOND} withSecond/></div>}
        </div>;
    }
}
