import * as React from 'react';

import IncidentsFeed from '../../Support/IncidentsFeed';

interface ICarIncidentsProps {
    carId: string;
}

interface ICarIncidentsState {

}

export default class CarIncidents extends React.Component<ICarIncidentsProps, ICarIncidentsState> {
    state: ICarIncidentsState = {};

    render() {
        const { carId } = this.props;

        return <div>
            <IncidentsFeed initialFiltersData={{ carId }}
                           isFiltersOn={
                               {
                                   type: true, status: true, since: true, until: true,
                                   carId: false, userId: true, sessionId: true,
                               }
                           }
                           hideColumns={{ car: true, fullIncidentButton: true }}/>
        </div>;
    }
}
