import { IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_CAR_INCIDENTS = 'GET_CAR_INCIDENTS',
    GET_CAR_INFO = 'GET_CAR_INFO',
    GET_CREATE_INCIDENTS_SCHEMA = 'GET_CREATE_INCIDENTS_SCHEMA',
    CREATE_INCIDENT = 'CREATE_INCIDENT',
    GET_PERFORM_INCIDENTS_SCHEMA = 'GET_PERFORM_INCIDENTS_SCHEMA',
    PERFORM_INCIDENTS = 'PERFORM_INCIDENTS'
}

export const CAR_INCIDENT_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_CAR_INCIDENTS]: {
        api: 'incident/list',
        cgiObj: {
            car_id: null,
            session_id: null,
            user_id: null,
            incident_id: null,
        },
    },
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_CREATE_INCIDENTS_SCHEMA]: {
        api: 'incident/create',
        cgiObj: {
            scheme: null,
        },
    },
    [REQUESTS.CREATE_INCIDENT]: {
        api: 'incident/create',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.GET_PERFORM_INCIDENTS_SCHEMA]: {
        api: 'incident/perform_transition',
        cgiObj: {
            scheme: null,
            incident_id: null,
        },
    },
    [REQUESTS.PERFORM_INCIDENTS]: {
        api: 'incident/perform_transition',
        method: REQUEST_METHOD.POST,
    },
};
