import * as React from 'react';

import { Dict } from '../../../../../types';
import { EMPTY_DATA, ONE_SECOND, RESERVATION_FEATURES } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import { Link } from '../../../../ui/Link';
import { copySessionText } from '../../../Chats/utils';
import { Copy } from '../../../Copy';

interface INextOrderProps {
    carNumber: string;
    data: Dict<any>[];
    className?: string;
}

interface INextOrderState {
    newOrder: Dict<any> | null;
}

export class NextOrder extends React.Component<INextOrderProps, INextOrderState> {
    state: INextOrderState = {
        newOrder: null,
    };

    componentDidMount() {
        this.getInfo();
    }

    componentDidUpdate(prevProps: Readonly<INextOrderProps>): void {
        if (this.props.data.length !== prevProps.data.length) {
            this.getInfo();
        }
    }

    getInfo() {
        const data = this.props.data || [];
        const newOrder = data.find(el => el.tag === RESERVATION_FEATURES) || null;

        this.setState({ newOrder });
    }

    getNextOrderCopyText() {
        const newOrder = this.state.newOrder;

        if (newOrder && newOrder.performer_info) {
            const user = newOrder.performer_info;
            const { carNumber } = this.props;

            return copySessionText(user, carNumber);
        }

        return '';
    }

    render() {
        return this.state.newOrder && <div className={this.props.className ?? ''}>
            <Copy text={this.getNextOrderCopyText()}
                  internalTooltipId={'next_order'}>
                <table>
                    <tbody>
                        <tr>
                            <td colSpan={2}>
                                <strong>Дальше: </strong>
                            </td>
                        </tr>
                        <tr>
                            <td colSpan={2}>
                                {this.state.newOrder.performer_info
                                    ? <Link href={`#/clients/${this.state.newOrder.performer_info.id}/info`}>
                                        {this.state.newOrder.performer_info.name}
                                    </Link>
                                    : EMPTY_DATA}
                            </td>
                        </tr>
                        <tr>
                            <td>
                                {this.state.newOrder.Offer
                                && this.state.newOrder.Offer.Name},
                            </td>
                            <td>
                                <strong>До: </strong>
                                <FormatDate value={this.state.newOrder.Offer
                                            && this.state.newOrder.Offer.Deadline * ONE_SECOND}/>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </Copy>
        </div>
            || null;
    }
}
