import React, { useEffect, useState } from 'react';

import { Request2 } from '../../../utils/request';
import Spin from '../../Spin';
import { CAR_REQUESTS, REQUESTS } from '../request';
import { IMapStateToProps } from './index';

interface ICarLessorProps extends IMapStateToProps {
    carId: string;
}

export const CarLessor = React.memo((props: ICarLessorProps) => {
    const { blockRules, carId } = props;
    const showLeasingProvider = blockRules?.ShowLeasingProvider;

    const [isLoading, setLoading] = useState<boolean>(false);
    const [error, setError] = useState<Error | null>(null);
    const [lessor, setLessor] = useState<string | null>(null);

    useEffect(() => {
        const request = new Request2({ requestConfigs: CAR_REQUESTS });

        if (showLeasingProvider && carId) {
            setLoading(true);
            request.exec(REQUESTS.GET_ATTACHMENTS_LIST, {
                queryParams: {
                    car_id: carId,
                },
            })
                .then(response => {
                    const lessorData = response?.attachments?.find(el => el.data?.lessor);
                    lessorData ? setLessor(lessorData.data?.lessor) : null;
                    setLoading(false);
                    setError(null);
                })
                .catch(error => {
                    setError(error);
                    setLoading(false);
                });
        }

        return () => {
            request.abort();
        };
    }, [carId]);

    return showLeasingProvider
        ? <>
            <td><b>Лизингодатель</b></td>
            <td>
                {isLoading
                    ? <Spin size={'s'}/>
                    : error
                        ? 'error :('
                        : lessor}
            </td>
        </>
        : null;
});
