import * as React from 'react';

import { ISearchControls, WithSearchControls } from '../../../../decorators/SearchControls';
import { ONE_DAY } from '../../../constants';
import Checkbox from '../../../ui/Checkbox';
import Select from '../../../ui/Select';
import Photos from '../../Photos';
import style from './index.css';

interface ICarPhotosProps extends ISearchControls {
    carId: string;
}

interface ICarPhotosState {
    source: null | string;
    onlyMarked: boolean;
}

const DEFAULT_SOURCE_FILTER = 'feedback';
const SUBTRACT_DAYS = 7;

@WithSearchControls({
    since: +new Date() - (SUBTRACT_DAYS * ONE_DAY),
    until: +new Date(),
    dateClassName: style.date_controls,
})
export default class CarPhotos extends React.Component<ICarPhotosProps, ICarPhotosState> {
    state: ICarPhotosState = {
        source: DEFAULT_SOURCE_FILTER,
        onlyMarked: false,
    };

    onSelect(source) {
        this.setState({ source });
    }

    onMarkedSelect(onlyMarked) {
        this.setState({ onlyMarked });
    }

    render() {
        return <>
            <div className={style.additional_controls}>
                <Select addingOddVariants
                        placeholder={'Источник'}
                        onSelect={this.onSelect.bind(this)}
                        initialValues={[DEFAULT_SOURCE_FILTER]}
                        options={[
                            { value: '', text: 'Показать всё' },
                            { value: DEFAULT_SOURCE_FILTER, text: 'Фидбек' },
                            { value: 'srv_cleaning', text: 'Мойка' },
                            { value: 'srv_fueling', text: 'Заправка' },
                            { value: 'srv_tech', text: 'Техник' },
                            { value: 'srv_tyre_service', text: 'Фотки колёс' },
                            { value: 'default', text: 'Default' },

                        ]}/>
            </div>

            <div className={style.checkbox_control}>
                <div className={style.title}>Только размеченные</div>
                <Checkbox checked={this.state.onlyMarked}
                          onChange={this.onMarkedSelect.bind(this)}/>
            </div>

            <Photos car_id={this.props.carId}
                    since={this.props.since}
                    filters={{
                        source: this.state.source,
                    }}
                    until={this.props.until}
                    onlyMarked={this.state.onlyMarked}/>
        </>;
    }
}
