import React, { useState } from 'react';

import { DIGIT_THOUSAND, ONE_HOUR, ONE_KILOMETER } from '../../../constants';
import { useRequestHandler } from '../../../hooks/useRequestHandler';
import { Button } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import { Input } from '../../../ui/Input';
import { Request2 } from '../../../utils/request';
import style from '../index.css';
import { CAR_REQUESTS, REQUESTS } from '../request';

interface IStartSessionModalProps {
    onClose: () => void;
    carId: string;
}

const DEFAULT_SPEED = 90;
const DEFAULT_LON_LAT = '55.75321579, 37.62250519';
const COMMAND = 'MOVE_TO_COORD';

export const StartSessionModal = React.memo((props: IStartSessionModalProps) => {
    const [speed, setSpeed] = useState<number>(DEFAULT_SPEED);
    const [lonLat, setLonLat] = useState<string>(DEFAULT_LON_LAT);

    const request = new Request2({ requestConfigs: CAR_REQUESTS });

    const requestOptions = React.useMemo(() => {
        const coords = lonLat.split(',')?.map(el => el.trim());

        return {
            requestName: REQUESTS.CAR_CONTROL,
            requestOptions: {
                body: {
                    car_id: props.carId,
                    command: COMMAND,
                    latitude: coords[0],
                    longitude: coords[1],
                    speed: speed * ONE_KILOMETER / (ONE_HOUR / DIGIT_THOUSAND),
                },
            },
        };
    }, [lonLat, speed]);

    const responseHandler = () => {
        if (!error) {
            props.onClose();
        }
    };

    const [isLoading, , error, makeResponse] = useRequestHandler(request, requestOptions, responseHandler);

    React.useEffect(() => {
        return () => {
            request.abort();
        };
    }, []);

    return <Window onClose={props.onClose.bind(null)} title={'Начать движение'} collapseError={error}>
        <div className={style.inputs_wrapper}>
            <Input value={DEFAULT_SPEED} onChange={setSpeed} placeholder={'Speed (km/h)'}/>
            <Input value={DEFAULT_LON_LAT} onChange={setLonLat} placeholder={'Lat, Lon'}/>
        </div>

        <Button isLoading={isLoading} onClick={makeResponse.bind(null)}>
            Подтвердить
        </Button>
    </Window>;
});
