import * as React from 'react';

import { TAG_ACTION } from '../../../../../../types';
import { EMPTY_DATA, ONE_SECOND } from '../../../../../constants';
import FormatDate from '../../../../../ui/FormatDate';
import { IconBLE } from '../../../../../ui/Icons';
import { Link } from '../../../../../ui/Link';
import { normalizeHash2, replaceUserNameToLink } from '../../../../../utils/utils';
import * as style from '../../index.css';

const TELEMATICS_TAG_NAME = 'telematics';

interface ITagsHistoryItemProps {
    index: number;
    item: any;
    showPhoto: any;
    _style: any;
}

class TagsHistoryItem extends React.Component<ITagsHistoryItemProps> {
    render() {
        const { index, item, showPhoto, _style } = this.props;

        return <div style={_style} className={style.row}>
            <span className={style.cell}>{index}</span>
            <span className={style.cell}>
                <FormatDate value={item.timestamp * ONE_SECOND} withSecond={true}/>
            </span>
            <span className={style.cell}>
                {
                    item.action || EMPTY_DATA
                }
                <div>
                    {
                        item.event_id
                            ? <Link href={normalizeHash2(
                                {
                                    carId: item.object_id,
                                    extraPath: `tag-history-details/${item.event_id}`,
                                    href: location.href,
                                })}> detail </Link>
                            : ''
                    }
                    &nbsp;
                    {
                        item.event_id && item.tag_name === TELEMATICS_TAG_NAME &&
                        <Link href={normalizeHash2(
                            {
                                carId: item.object_id,
                                extraPath: `car-telematic-status/${item.event_id}`,
                                href: location.href,
                            })}> status </Link> || ''
                    }
                </div>
            </span>
            <span className={style.cell}>
                {
                    item.action === TAG_ACTION.ADD_SNAPSHOT
                        ? <span className={style.show_photo}
                                onClick={showPhoto.bind(this, item.event_id)}>📷</span>
                        : ''
                }
                {
                    item?.tag_details?.TransformationSkippedByExternalCommand
                        ? <IconBLE/>
                        : ''
                }
            </span>
            <span className={style.cell}>
                <div title={`${item.tag_display_name}\n${item.tag_name}`}>
                    <span>{item.tag_display_name || item.tag_name || EMPTY_DATA}</span>
                </div>
            </span>
            <span className={style.cell}>
                {
                    item.user_data_full && item.user_data_full.username
                   && <Link href={`#/clients/${item.user_id}/tags-history`} title={item.user_id}>
                       {item.user_data_full.username}
                   </Link>
                   || replaceUserNameToLink(item.user_id)
                }
                <div>
                    {item.user_data_full
                        && [item.user_data_full.last_name
                        || '', item.user_data_full.first_name || ''].join(' ')}
                </div>
            </span>
            <span className={style.cell}>
                {item.originator_id
                    ? <Link href={`#/clients/${item.originator_id}/info`}
                            title='Действие было инициировано другим пользователем'>Автор</Link>
                    : EMPTY_DATA}
            </span>
            <span className={style.cell}/>
        </div>;
    }
}

export default TagsHistoryItem;
