import React, { useState } from 'react';

import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import { Window } from '../../../../ui/FullModal';
import { Link } from '../../../../ui/Link';
import { IPhotoItem, PhotoItem } from '../../../Photos/PhotoItem';
import { PictureGallery } from '../../../PictureGallery';
import { IComplaintTag } from '../types';
import style from './index.css';

export const ComplaintHistoryModal = React.memo((props: { onClose: () => void; tag: IComplaintTag }) => {
    const tag = props.tag;
    const complaints = props.tag.complaint_sources?.slice() ?? [];
    const sortedComplaints = complaints.sort((a, b) => {
        return b.is_confirmed - a.is_confirmed;
    });

    return <Window onClose={props.onClose.bind(null)} title={'Жалоба на авто'}>
        <div>
            <b>Статус:</b> {props.tag.status ?? EMPTY_DATA}
        </div>

        <div>
            <Link href={`#/clients/${tag.problem_user_id}`} target={'_blank'}>Виновник</Link>
        </div>

        <div>
            <Link href={`#/session/${tag.problem_session_id}`} target={'_blank'}>Сессия</Link>
        </div>

        {sortedComplaints.length
            ? <div>
                <table className={style.complaint_table}>
                    <thead>
                        <tr>
                            <td>#</td>
                            <td>Вес</td>
                            <td>Фото</td>
                            <td>Кто пожаловался</td>
                            <td>Категория</td>
                            <td>Подтверждение</td>
                            <td>Дата</td>
                            <td>Комментарий</td>
                        </tr>
                    </thead>

                    <tbody>
                        {sortedComplaints.map((el, ind) => {
                            const isConfirmed = el.is_confirmed;

                            return <tr key={`complaint-${ind}`} className={`${isConfirmed ? style.confirmed : ''}`}>
                                <td>{ind + 1}</td>

                                <td>{el.added_weight}</td>

                                <td>
                                    {el.image_paths?.length
                                        ? <ComplaintPhotos photos={el.image_paths} session={tag.problem_session_id}/>
                                        : EMPTY_DATA
                                    }
                                </td>

                                <td>
                                    <Link href={`#/clients/${el.user_id}`} target={'_blank'}>
                                    Пользователь
                                    </Link>
                                </td>

                                <td>{el.source_name}</td>

                                <td>{el.is_confirmed + ''}</td>

                                <td>
                                    {el.created_at
                                        ? <FormatDate value={el.created_at / ONE_SECOND}/>
                                        : null
                                    }
                                </td>

                                <td className={style.comment}>{el.comment || EMPTY_DATA}</td>
                            </tr>;
                        })}
                    </tbody>
                </table>
            </div>
            : null
        }
    </Window>;
});

export const ComplaintPhotos = React.memo((props: { photos: string[]; session: string }) => {
    const [isModalOpened, openModal] = useState<boolean>(false);
    const [imgIndex, setIndex] = useState<number | null>(null);

    const photoArray = props.photos.map(el => {
        return { link: el };
    });

    return <div>
        <Link onClick={openModal.bind(null, true)}>
            Фото ({props.photos.length})
        </Link>

        {isModalOpened
            ? <Window onClose={openModal.bind(null, false)}>
                {props.photos.map((el, ind) => {
                    const photoItem = {
                        url: el,
                        user_session_id: props.session,
                    } as IPhotoItem;

                    return <div className={style.photo_item}
                                key={'complPhoto' + ind}
                                onClick={setIndex.bind(null, ind)}>
                        <PhotoItem index={ind} photo={photoItem}/>
                    </div>;
                })
                }
            </Window>
            : null
        }

        {imgIndex !== null
            ? <PictureGallery initialIndex={imgIndex ?? 0}
                              pictures={photoArray}
                              onClose={setIndex.bind(null, null)}/>
            : null
        }
    </div>;
});
