import * as React from 'react';

import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import { JsonModal } from '../../../../ui/FullModal/JsonModal';
import { Request2 } from '../../../../utils/request';
import Spin from '../../../Spin';
import { CAR_REQUESTS as requestConfigs } from '../../request';
import { returnBack } from '../../returnBack';

interface IMoreTagInfoProps {
    location: any;
    request: () => any;
    header: string;
}

const SENSORS_DISTANCE = 2103;

enum SENSORS {
    DISTANCE = SENSORS_DISTANCE
}

interface IMoreTagInfoState {
    isLoading: boolean;
    error: Error | null;
    data: any;
}

interface ISensor {
    id: SENSORS;
    value: any;
    since: number;
    timestamp: number;
}

export class MoreTagInfoModal extends React.Component<IMoreTagInfoProps, IMoreTagInfoState> {
    state: IMoreTagInfoState = {
        isLoading: false,
        error: null,
        data: {},
    };
    request = new Request2({
        requestConfigs,
    });

    onClose() {
        returnBack();
    }

    componentDidMount() {
        this.loadData();
    }

    loadData() {
        this.setState({
            isLoading: true,
        }, () => {
            this.props.request()
                .then((response) => {
                    this.setState({
                        data: response,
                        isLoading: false,
                    });
                })
                .catch((error) => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    render() {
        const sensors: ISensor[] = this.state.data
            && this.state.data.snapshot
            && this.state.data.snapshot.data
            && this.state.data.snapshot.data.sensors;
        const tagName = this.state.data && this.state.data.tag && this.state.data.tag.tag || EMPTY_DATA;

        const distance = sensors && sensors.filter(_el => _el.id === SENSORS.DISTANCE)[0];

        return <JsonModal onClose={this.onClose.bind(this)}
                          obj={this.state.data}
                          title={`${this.props.header} ${tagName}`}>
            {
                this.state.isLoading
                && <Spin/>
                || distance
                && <div>
                    <div>
                        <strong>Пробег</strong> (<i>{SENSORS.DISTANCE}</i> ): <strong>
                            {distance.value}
                        </strong>
                        <i title={'since'}> | <FormatDate value={distance.since * ONE_SECOND}/> | </i>
                        <i title={'timestamp'}><FormatDate value={distance.timestamp * ONE_SECOND}/></i>
                    </div>
                </div>
            }
        </JsonModal>;
    }
}
