import * as React from 'react';

import { Button, ButtonTypes } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import * as coreStyle from '../../../../ui/index.css';
import * as styleTable from '../../../../ui/Table/index.css';
import Spin from '../../../Spin';
import { ICarFormattedTag } from '../types';

interface IRepairTagInfoModalProps {
    currentRepairTag: ICarFormattedTag | null;
    closeRepairInfo: () => void;
    rejectRequest: () => void;
}

export const RepairTagInfoModal = (props: IRepairTagInfoModalProps) => {
    const { currentRepairTag, closeRepairInfo, rejectRequest } = props;

    return <Window title={'Информация по заявке'} onClose={closeRepairInfo && closeRepairInfo.bind(null)}>
        <div>
            {currentRepairTag
                ? <>
                    <table className={styleTable.table}>
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Показатель</th>
                                <th>Значение</th>
                            </tr>
                        </thead>
                        <tbody>
                            {Array.isArray(currentRepairTag)
                        && currentRepairTag.map((tag, index) => {
                            return <tr key={tag.name}>
                                <td>{++index}</td>
                                <td>{tag.name}</td>
                                <td>{tag.value}</td>
                            </tr>;
                        })}
                        </tbody>
                    </table>
                    <div className={coreStyle.button_container}>
                        <Button colorType={ButtonTypes.negative}
                                onClick={rejectRequest && rejectRequest.bind(null)}>Отменить заявку</Button>

                        <Button basic
                                onClick={closeRepairInfo && closeRepairInfo.bind(null)}>Закрыть</Button>
                    </div>
                </>
                : <Spin/>
            }
        </div>
    </Window>;
};
