import * as React from 'react';

import { Dict } from '../../../../../types';
import LS from '../../../../utils/localStorage/localStorage';
import { Request2 } from '../../../../utils/request';
import { PictureGallery } from '../../../PictureGallery';
import { CAR_REQUESTS as requestConfigs, REQUESTS } from '../../request';

interface ISnapshotPhotoProps {
    eventId: string;
    onClose: () => void;
}

interface ISnapshotPhotoState {
    isLoading: boolean;
    error: Error | null;
    snapshot: Dict<any>;
}

export class SnapshotPhoto extends React.Component <ISnapshotPhotoProps, ISnapshotPhotoState> {
    state: ISnapshotPhotoState = {
        isLoading: false,
        error: null,
        snapshot: {},
    };
    request = new Request2({
        requestConfigs,
    });
    ls = new LS();

    componentDidMount(): void {
        this.getData();
    }

    getData() {
        this.setState({
            isLoading: true,
        }, () => {
            this.request.exec(REQUESTS.GET_CAR_TAGS_HISTORY_DETAIL, { queryParams: { event_id: this.props.eventId } })
                .then(response => {
                    this.setState({
                        isLoading: false,
                        snapshot: response.snapshot || {},
                    });
                })
                .catch((error) => {
                    this.setState({ error });
                });
        });
    }

    render() {
        const pictures = (this.state?.snapshot?.data?.images || [this.state?.snapshot?.data || {}])?.map(img => {
            const { marker = '', path = '' } = img;

            return {
                link: `https://carsharing-tags.s3`
                    + `${this.ls.envIsTesting() ? '.mdst' : ''}`
                    + `.yandex.net/${path}`,
                title: `Маркер: ${marker}; |  Комментарий: ${this.state?.snapshot?.data?.comment}`,
            };
        });

        return <PictureGallery pictures={pictures} onClose={this.props.onClose.bind(this)}/>;
    }
}
