import * as React from 'react';

import { EMPTY_DATA } from '../../../../constants';
import { JsonModal } from '../../../../ui/FullModal/JsonModal';
import { Request2 } from '../../../../utils/request';
import Spin from '../../../Spin';
import { CAR_REQUESTS as requestConfigs, REQUESTS } from '../../request';
import { returnBack } from '../../returnBack';

export class TelematicStatus extends React.Component<any, any> {
    state: any = {
        isLoading: false,
        data: {},
        emptyHandler: false,
    };
    request = new Request2({
        requestConfigs,
    });

    componentDidMount() {
        this.loadData();
    }

    componentDidUpdate(prevProps: Readonly<any>): void {
        if (this.props.location.pathname !== prevProps.location.pathname) {
            this.loadData();
        }
    }

    loadData() {
        const eventId = this.props.match && this.props.match.params && this.props.match.params.eventId;
        const statusId = this.props.match && this.props.match.params && this.props.match.params.statusId;

        this.setState({ isLoading: true }, () => {
            if (statusId) {
                this.getTelematicStatus(statusId);
            } else {
                this.request.exec(REQUESTS.GET_CAR_TAGS_HISTORY_DETAIL,
                    { queryParams: { event_id: eventId } })
                    .then(response => {
                        if (response.tag && response.tag.handler) {
                            this.getTelematicStatus(response.tag.handler);
                        } else {
                            this.setState({
                                data: response,
                                isLoading: false,
                                emptyHandler: true,
                            });
                        }
                    })
                    .catch(() => {
                        this.setState({
                            isLoading: false,
                        });
                    });
            }
        });
    }

    getTelematicStatus(statusId: string) {
        this.request.exec(REQUESTS.GET_TELEMATICS_STATUS, { queryParams: { id: statusId } })
            .then(response => {
                this.setState({
                    data: response,
                    isLoading: false,
                    emptyHandler: false,
                });
            })
            .catch(() => {
                this.setState({
                    isLoading: false,
                });
            });
    }

    onClose() {
        returnBack();
    }

    render() {
        return <JsonModal title={`Детали выполнения ${this.state.emptyHandler ? `< отсутствует tag.handler >` : ''}`}
                          obj={this.state.data}
                          onClose={this.onClose.bind(this)}>
            {this.state.isLoading
            && <Spin/>
            || <>
                <div>
                    <strong>status</strong>: {this.state.data
                    && this.state.data.task
                    && this.state.data.task.data
                    && this.state.data.task.data.status
                    || EMPTY_DATA}
                </div>
                <div>
                    <strong>message</strong>: {this.state.data
                    && this.state.data.task
                    && this.state.data.task.data
                    && this.state.data.task.data.message
                    || EMPTY_DATA}
                </div>
            </>}
        </JsonModal>;
    }
}
