import * as React from 'react';

import { Dict } from '../../../../types';
import { Request2 } from '../../../utils/request';
import { IStore } from '../../App/store';
import { IConstantsFaceTag } from '../../TagModal/component';
import { CAR_REQUESTS as requestConfigs, REQUESTS } from '../request';
import { CarCurrentTags } from './CarCurrentTags';
import { CarTagsHistory } from './CarTagsHistory';
import * as style from './index.css';
import { ITag } from './types';

const TAGS_ACTIONS = ['add', 'set_performer', 'drop_performer', 'remove'];
const TAG_PREFIX = 'old_';

interface ICarTagsViewProps extends IStore, IConstantsFaceTag {
    carId: string;
    importantCarTags?: Dict<any>;
}

interface ICarTagsViewState {
    carTagsIsLoading: boolean;
    loadingError: Error | null;
    allTagsHash: Dict<ITag>;
    iface_tag_implementations: Dict<any>;
    history: any;
}

export default class CarTagsView extends React.Component<ICarTagsViewProps, ICarTagsViewState> {
    state: ICarTagsViewState = {
        carTagsIsLoading: false,
        loadingError: null,
        allTagsHash: {},
        iface_tag_implementations: {},
        history: {},
    };
    request = new Request2({
        requestConfigs,
    });

    componentDidMount(): void {
        this.getTagsSchemaInfo();
    }

    componentDidUpdate(prevProps: Readonly<ICarTagsViewProps>): void {
        if (this.props.carId !== prevProps.carId) {
            this.getTagsSchemaInfo();
        }
    }

    componentWillUnmount() {
        this.request.abort();
    }

    getTagsSchemaInfo() {
        Promise.all([
            this.request.exec(REQUESTS.GET_TAGS),
            this.props.constantsIFaceTag(''), // запрашиваем схемы всех тегов, для подкрашивания дополнительных параметров в таблице
        ])
            .then(response => {
                const allTags: ITag[] = response[0] && response[0].records || [];
                const allTagsHash = allTags && allTags.reduce((prev, cur) => {
                    prev[cur.name] = cur;

                    return prev;
                }, {});

                const iface_tag_implementations = response[1] && response[1].iface_tag_implementations || {};

                this.setState({
                    allTagsHash,
                    iface_tag_implementations,
                    carTagsIsLoading: false,
                });
            });
    }

    onLoadedHistory(history) {
        this.setState({
            history: history?.reduce((_p, _c) => {
                const tag_id = _c?.tag_id || '';
                if (TAGS_ACTIONS.includes(_c.action) && !_c?.tag_details?.tag?.includes(TAG_PREFIX)) {
                    if (!_p.hasOwnProperty(tag_id)) {
                        _p[tag_id] = [_c];
                    } else {
                        _p[tag_id].push(_c);
                    }
                }

                return _p;
            }, {}) || [],
        });
    }

    render() {
        return <div className={style.car_tags}>
            <CarCurrentTags AdminUser={this.props.AdminUser}
                            importantCarTags={this.props.importantCarTags}
                            iface_tag_implementations={this.state.iface_tag_implementations}
                            allTagsHash={this.state.allTagsHash}
                            history={this.state.history}
                            carId={this.props.carId}/>
            <div className={style.tags_history}>
                <h4>История тегов:</h4>
                <CarTagsHistory allTagsHash={this.state.allTagsHash}
                                carId={this.props.carId}
                                onLoadedHistory={this.onLoadedHistory.bind(this)}/>
            </div>
        </div>;
    }
}
