import { connect } from 'react-redux';
import { withRouter } from 'react-router';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { getRawSetting2 } from '../../../utils/getRawSetting';
import { IStore } from '../../App/store';
import { important_car_tags } from '../../InterfaceAdminConfig/adminConfigKeys';
import { mapDispatchToPropsWithFetchIFace } from '../../TagModal';
import CarTagsView from './component';

const key = `${GVARS_INTERFACE_ADMIN_PREFIX}.${important_car_tags}`;

export const mapStateToProps = (store: IStore) => {
    return {
        AdminUser: store.AdminUser,
        Lang: store.Lang,
        importantCarTags: getRawSetting2(store, key),
    };
};

export default withRouter<any, any>(connect(mapStateToProps, mapDispatchToPropsWithFetchIFace)(CarTagsView));
