import { Dict } from '../../../../types';
import { BasicUserInfo } from '../../../models/user';

export enum TagActions {
    RESET = 'reset',
    DONE = 'done',
}

export interface ITag {
    timestamp: number;
    meta: string | {
        actions: { name: string }[];
        old_status: string;
    };
    entities?: string[];
    description_index: string;
    type: string;
    display_name: string;
    name: string;
    comment: string;
    unique_policy: string;
    default_priority?: string;
    priority: number;
    tag: string;
    tag_id: string;
    tag_name: string;
    user_data_full: Dict<any>;
    performer: any;
    performer_details?: typeof BasicUserInfo;
    user_id?: string;
}

export interface ICarFormattedTag extends ITag {
    isCarRepairTag: boolean;
    isRequested: boolean;
}

export interface IComplaintTag extends ITag {
    status: string;
    complaint_sources: any[];
    problem_user_id: string;
    problem_session_id: string;
    image_paths: string[];
}
