import React, { useEffect, useState } from 'react';

import { LONGTERM_FEED_TAG } from '../../../constants';
import { LongtermFeedButton } from '../../../utils/getLongtermFeedButton';
import { ILongtermFeedTag } from '../../../utils/getLongtermFeedButton/getLongtermFeedLink';
import { Request2 } from '../../../utils/request';
import style from '../index.css';
import { CAR_REQUESTS, REQUESTS } from '../request';

export const LongtermFeedButtonWrapper = React.memo((props: { user_id: string }) => {
    const [isLoading, setIsLoading] = useState(false);
    const [error, setError] = useState(null);
    const [tag, setTag] = useState<ILongtermFeedTag | null>(null);

    useEffect(() => {
        const request = new Request2({ requestConfigs: CAR_REQUESTS });

        setIsLoading(true);
        props.user_id && request.exec(REQUESTS.GET_USER_TAGS, {
            queryParams: { object_id: props.user_id },
        })
            .then(response => {
                const longtermTag = response.records?.find(el => {
                    return el.tag === LONGTERM_FEED_TAG;
                });

                setIsLoading(false);
                setError(null);
                setTag(longtermTag);
            })
            .catch(error => {
                setError(error);
                setIsLoading(false);
            });

        return () => {
            request.abort();
        };
    }, [props.user_id]);

    return tag
        ? <LongtermFeedButton tag={tag as ILongtermFeedTag}
                              isLoading={isLoading}
                              error={error}
                              className={style.longterm_link}/>
        : null;
});
