import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    CREATE_CHAT = 'CREATE_CHAT',
    PERFORM_CHAT = 'PERFORM_CHAT',
    SEND_MESSAGE = 'SEND_MESSAGE',
    DEFER = 'DEFER',
}

export const CAR_REQUESTS: IComponentRequest = {
    [REQUESTS.CREATE_CHAT]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/add',
    },
    [REQUESTS.SEND_MESSAGE]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chat/message',
        cgiObj: {
            user_id: null,
            chat_id: null,
        },
    },
    [REQUESTS.PERFORM_CHAT]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'user/tag/perform/start',
    },

    [REQUESTS.DEFER]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'request/defer',
        cgiObj: {
            tag_id: null,
        },
    },
};
