import React from 'react';

import { Window } from '../../../ui/FullModal';
import { Link } from '../../../ui/Link';
import Select, { IOptionInfo } from '../../../ui/Select';
import { PhotoItem } from '../../Photos/PhotoItem';
import { DeletePhotoControl } from '../../Photos/PictureGalleryControItem/DeletePhotoControl';
import { PictureGallery } from '../../PictureGallery';
import styles from './index.css';

const ShowDamagesLikeClient = ({ carInfo }) => {
    const [modalIsOpen, showModal] = React.useState(false);
    const [showImgIndex, setImage] = React.useState(null);
    const [damLevelOptions, setOptions] = React.useState<IOptionInfo[]>([]);
    const [selectedOption, setSelectedOption] = React.useState<string>('');
    const [photosToShow, setPhotos] = React.useState<any[]>(carInfo.photos ?? []);
    const images = carInfo.photos?.reduce?.((_p, _c) => {
        return [..._p, ..._c.elements];
    }, []) || [];

    let prevCount = 0;
    const currentPhoto = images[showImgIndex ?? 0] ?? {};

    React.useEffect(() => {
        const levels: string[] = [];

        carInfo.photos?.forEach(photo => {
            photo?.elements?.forEach(el => {
                const level = el?.markups?.[0]?.damage_level;
                level && !levels.includes(level) ? levels.push(level) : null;
            });
        });

        const damLevelOptions = levels.map(level => {
            return {
                value: level,
            };
        });

        setOptions(damLevelOptions);
    }, [carInfo.number]);

    React.useEffect(() => {
        if (selectedOption) {
            const photos = carInfo.photos.slice();

            const newPhotosToShow: any = [];

            photos?.forEach(photo => {
                const filteredElements = photo.elements?.filter(el => {
                    return el?.markups?.[0]?.damage_level === selectedOption;
                });

                filteredElements.length
                    ? newPhotosToShow.push({ ...photo, elements: filteredElements })
                    : null;
            });

            setPhotos(newPhotosToShow);
        } else {
            setPhotos(carInfo.photos);
        }
    }, [selectedOption, carInfo.photos?.length]);

    return <>
        {images.length
            ? <Link onClick={showModal.bind(null, true)}>Известные повреждения ({images.length})</Link>
            : null
        }

        {modalIsOpen
            ? <Window onClose={showModal.bind(null, false)} title={'Фото известных повреждений'}>
                <Select options={damLevelOptions}
                        onSelect={setSelectedOption.bind(null)}
                        placeholder={'DamageLevel'}/>

                {photosToShow?.map?.((group, _index) => {
                    prevCount = prevCount + (_index && carInfo.photos[_index - 1]?.elements?.length || 0);

                    return <div key={_index}>
                        <h3>{group.title}</h3>
                        <div className={styles.grid}>
                            {
                                group?.elements?.map((photo, index) => {
                                    const indx = prevCount + index;

                                    return <div key={photo.image_id}
                                                onClick={setImage.bind(null, indx)}>
                                        <PhotoItem index={indx} photo={photo}>
                                            <CustomFooter id={photo.id} title={photo.title}/>
                                        </PhotoItem>
                                    </div>;
                                })
                            }
                        </div>
                    </div>;
                })
                }
            </Window>
            : null
        }

        {showImgIndex !== null
            ? <PictureGallery initialIndex={showImgIndex || 0}
                              pictures={images}
                              onChange={setImage.bind(null)}
                              controls={<DeletePhotoControl photo={currentPhoto}/>}
                              onClose={setImage.bind(null, null)}/>
            : null
        }
    </>;
};

export { ShowDamagesLikeClient };

const CustomFooter = ({ id, title }) => {
    return <div className={styles.custom_footer}>
        <div className={styles.custom_footer_item}>{id}</div>
        <div className={styles.custom_footer_item}>{title}</div>
    </div>;
};
