import * as React from 'react';

import { EMPTY_DATA } from '../../constants';
import { BadgeItem } from '../Clients/Achievements2/Badge';
import * as style from './index.css';

export const SPECIAL_FLEET_BADGE = () => {
    const SPECIAL_FLEET_LOGO_URL = 'https://carsharing.s3.yandex.net/drive/static/tag-icons/v6/autopark.png';
    const SPECIAL_FLEET_TITLE = 'Выделенный парк';

    return <BadgeItem url={SPECIAL_FLEET_LOGO_URL} title={SPECIAL_FLEET_TITLE} enabled/>;
};

export const CarLabel = React.memo((props: { label; className?: string }) => {
    const propsClass = props.className ? props.className : '';

    return <div title={props.label} className={`${style.label_tag} ${propsClass}`}>
        {props.label ? props.label : EMPTY_DATA}
    </div>;
});
