import { getActuality } from '../../constants';
import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';
import { DEFAULT_PAGE_SIZE } from './constants';

export enum REQUESTS {
    GET_CAR_INFO = 'GET_CAR_INFO',
    GET_USER_INFO = 'GET_USER_INFO',
    GET_SESSION = 'GET_SESSION',
    GET_TELEMATICS_STATE = 'GET_TELEMATICS_STATE',
    GET_TELEMATICS_HISTORY = 'GET_TELEMATICS_HISTORY',
    GET_TELEMATICS_JSON = 'GET_TELEMATICS_JSON',
    CAR_CONTROL = 'CAR_CONTROL',
    GET_CAR_UPSERT_HISTORY = 'GET_CAR_UPSERT_HISTORY',
    GET_MODELS = 'GET_MODELS',
    UPSERT_CAR_INFO = 'UPSERT_CAR_INFO',
    GET_ACCEPTANCE_PHOTOS = 'GET_ACCEPTANCE_PHOTOS',
    WRITE_LOG = 'WRITE_LOG',
    GET_PASSWORD = 'GET_PASSWORD',
    CAR_ACTION_STAFF = 'CAR_ACTION_STAFF',
    FINISH_CAR_SESSION = 'FINISH_CAR_SESSION',
    GET_TAGS = 'GET_TAGS',
    GET_CAR_TAGS = 'GET_CAR_TAGS',
    GET_CAR_DAMAGES = 'GET_CAR_DAMAGES',
    GET_CAR_TAGS_HISTORY = 'GET_CAR_TAGS_HISTORY',
    GET_CAR_TAGS_HISTORY_DETAIL = 'GET_CAR_TAGS_HISTORY_DETAIL',
    GET_TAG_DETAILS = 'GET_TAG_DETAILS',
    GET_MAJOR_SERVICE_TAG_INFO = 'GET_MAJOR_SERVICE_TAG_INFO',
    GET_MAJOR_LAST_TYRE = 'GET_MAJOR_LAST_TYRE',
    GET_MAINTENANCE_INFO = 'GET_MAINTEANCE_INFO',
    GET_ATTACHMENTS_LIST = 'GET_ATTACHMENTS_LIST',
    GET_ATTACHMENTS_HISTORY = 'GET_ATTACHMENTS_HISTORY',
    REMOVE_ATTACHMENTS = 'REMOVE_ATTACHMENTS',
    REMOVE_MAINTENANCE = 'REMOVE_MAINTENANCE',
    UPSERT_MAINTENANCE = 'UPSERT_MAINTENANCE',
    ASSIGN_ATTACHMENT = 'ASSIGN_ATTACHMENT',
    REJECT_MAJOR_SERVICE_TAG = 'REJECT_MAJOR_SERVICE_TAG',
    GET_TELEMATICS_STATUS = 'GET_TELEMATICS_STATUS',
    DELETE_CAR_TAG = 'DELETE_CAR_TAG',
    FINISH_PERFORM = 'FINISH_PERFORM',
    CAR_TAG_CONFIRM = 'CAR_TAG_CONFIRM',
    CAR_TAG_REJECT = 'CAR_TAG_REJECT',
    GET_TAG_PHOTOS = 'GET_TAG_PHOTOS',
    UPDATE_OSAGO = 'UPDATE_OSAGO',
    RESET_HEAD = 'RESET_HEAD',
    GET_DAMAGES_MODEL = 'GET_DAMAGES_MODEL',
    GET_USER_TAGS = 'GET_USER_TAGS',
    GET_USERS_BY_ROLES = 'GET_USERS_BY_ROLES',
    SET_PERFORMER = 'SET_PERFORMER',
    CAR_ACTION = 'CAR_ACTION',
}

const GVARS_DAMAGES_MODEL_PREFIX = 'exp_damages.model';
const GVARS_TELEMATICS_JSON_PREFIX = 'service_app.settings.telematics_show_settings';

export const CAR_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
            traits: 'ReportValidatedPhotos',
        },
    },
    [REQUESTS.GET_DAMAGES_MODEL]: {
        api: 'settings/info',
        cgiObj: {
            prefix: GVARS_DAMAGES_MODEL_PREFIX,
            actuality: getActuality(),
        },
    },
    [REQUESTS.GET_USER_INFO]: {
        api: 'user/report',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_SESSION]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            session_id: null,
            user_id: null,
        },
    },
    [REQUESTS.GET_TELEMATICS_STATE]: {
        api: 'car/telematics/state',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_TELEMATICS_HISTORY]: {
        api: 'car/telematics/history',
        cgiObj: {
            imei: null,
            sensor_id: null,
            sensor_subid: null,
            car_id: null,
            source: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_TELEMATICS_JSON]: {
        api: 'settings/info',
        cgiObj: {
            prefix: GVARS_TELEMATICS_JSON_PREFIX,
            actuality: getActuality(),
        },
    },
    [REQUESTS.CAR_CONTROL]: {
        method: REQUEST_METHOD.POST,
        api: 'car/control',
    },
    [REQUESTS.GET_CAR_UPSERT_HISTORY]: {
        api: 'car/history',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_MODELS]: {
        api: 'model/info',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.UPSERT_CAR_INFO]: {
        method: REQUEST_METHOD.POST,
        api: 'car/edit',
        cgiObj: {
            force: null,
        },
    },
    [REQUESTS.GET_ACCEPTANCE_PHOTOS]: {
        api: 'car/photos',
        cgiObj: {
            car_id: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.WRITE_LOG]: {
        method: REQUEST_METHOD.POST,
        api: 'log/push',
    },
    [REQUESTS.WRITE_LOG]: {
        method: REQUEST_METHOD.POST,
        api: 'log/push',
    },
    [REQUESTS.GET_PASSWORD]: {
        api: 'car/telematics/password',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.CAR_ACTION_STAFF]: {
        api: 'car/control',
        cgiObj: {
            car_id: null,
            command: null,
        },
    },
    [REQUESTS.CAR_ACTION]: {
        api: 'car/control',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            car_id: null,
            action: null,
        },
    },
    [REQUESTS.FINISH_CAR_SESSION]: {
        api: 'sessions/drop',
        cgiObj: {
            evolution_mode: null,
            session_id: null,
        },
    },
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.GET_CAR_TAGS]: {
        api: 'car/tag/list',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_CAR_DAMAGES]: {
        api: 'photo/markup/get',
        cgiObj: {
            object_id: null,
            entity: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_CAR_TAGS_HISTORY]: {
        api: 'car/tag/history',
        cgiObj: {
            car_id: null,
            duration: null,
            tags: null,
            since: null,
            until: null,
            tag_id:null,
        },
    },
    [REQUESTS.GET_TAG_DETAILS]: {
        api: 'car/tag/details',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.GET_CAR_TAGS_HISTORY_DETAIL]: {
        api: 'car/tag/history/details',
        cgiObj: {
            event_id: null,
        },
    },
    [REQUESTS.GET_MAJOR_SERVICE_TAG_INFO]: {
        api: 'major/details',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.REJECT_MAJOR_SERVICE_TAG]: {
        api: 'major/cancel',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.GET_MAJOR_LAST_TYRE]: {
        api: 'major/last_tyre',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.GET_ATTACHMENTS_LIST]: {
        api: 'car/attachments/list',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_MAINTENANCE_INFO]: {
        api: 'maintenance/info',
        cgiObj: {
            vin: null,
        },
    },
    [REQUESTS.GET_ATTACHMENTS_HISTORY]: {
        api: 'car/attachments/history',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.REMOVE_ATTACHMENTS]: {
        api: 'car/attachments/unassign',
        cgiObj: {
            attachment_id: null,
        },
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.REMOVE_MAINTENANCE]: {
        api: 'maintenance/remove',
        cgiObj: {
            vin: null,
        },
    },
    [REQUESTS.UPSERT_MAINTENANCE]: {
        api: 'maintenance/upsert',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.ASSIGN_ATTACHMENT]: {
        api: 'attachments/assign',
        cgiObj: {
            car_id: null,
        },
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.GET_TELEMATICS_STATUS]: {
        api: 'car/telematics/status',
        cgiObj: {
            id: null,
        },
    },
    [REQUESTS.DELETE_CAR_TAG]: {
        api: 'car/tag/remove',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.FINISH_PERFORM]: {
        api: 'car/tag/perform/finish',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.CAR_TAG_CONFIRM]: {
        api: 'car/tags/propositions/confirm',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.CAR_TAG_REJECT]: {
        api: 'car/tags/propositions/reject',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.GET_TAG_PHOTOS]: {
        api: 'tag/photos',
        cgiObj: {
            car_id: null,
            tag_names: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.UPDATE_OSAGO]: {
        api: 'osago/update',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.RESET_HEAD]: {
        api: 'admin/drop_key',
        method: REQUEST_METHOD.POST,
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_USER_TAGS]: {
        api: 'user_tags/list',
        cgiObj: {
            object_id: null,
        },
    },
    [REQUESTS.GET_USERS_BY_ROLES]: {
        api: 'roles/users',
        cgiObj: {
            roles: null,
            page_size: DEFAULT_PAGE_SIZE,
        },
    },
    [REQUESTS.SET_PERFORMER]: {
        method: REQUEST_METHOD.POST,
        api: 'subordinate/set_performer',
        cgiObj: {
            worker_id: null,
            tag_id: null,
        },
    },
};
