import { storiesOf } from '@storybook/react';
import React from 'react';

import CarInfo from '../../models/car';
import CarNumber from './index';

require('../App/index.css');

storiesOf('CarNumber', module)
    .add('default', () => (
        <>
            <div>
                <CarNumber carInfo={{ number: 'а661аа777' } as typeof CarInfo}/>
                <CarNumber carInfo={{ number: '1' } as typeof CarInfo}/>
                <CarNumber carInfo={{
                    number: 'а661аа777',
                    former_numbers: [{ number: 'а661аа778' }],
                } as typeof CarInfo}/>
                <CarNumber carInfo={{
                    number: 'а661аа777',
                    former_numbers: [{ number: 'а660аb777' }],
                } as typeof CarInfo}/>
                <CarNumber carInfo={{ number: '' } as typeof CarInfo}/>
                <CarNumber carInfo={{ number: '12345678901234567890' } as typeof CarInfo}/>
            </div>
        </>
    ));
