import React from 'react';

import { EMPTY_DATA } from '../../constants';
import CarInfo from '../../models/car';
import Formatter from '../../utils/formatter';
import { Copy } from '../Copy/';
import style from './index.css';

interface INumber {
    number?: string;
    region?: number;
}

const numberStart = 0;
const numberFinish = 6;
const regionLength = 3;

const longNumberStart = 1;
const longNumberFinish = 4;
const lastTwoDigits = -2;

export function parseNumber(value: string): INumber {
    let rez: any;
    if (!value) {
        rez = false;
    } else {
        let number = value && value.slice(numberStart, numberFinish) || EMPTY_DATA;
        const region = value && Number(value?.substr(numberFinish, regionLength)) || 0;
        number = number.length >= numberFinish
            ? number[0] + ' ' + number.slice(longNumberStart, longNumberFinish) + ' ' + number.slice(lastTwoDigits)
            : number;
        rez = {
            number,
            region,
        };
    }

    return rez;
}

const CarNumber = (props: { carInfo?: typeof CarInfo; value?: string; externalTooltipId?: string}) => {
    const { number, former_numbers } = props?.carInfo || {} as typeof CarInfo;
    const formattedNumber = (number && parseNumber(number)) || (props?.value && parseNumber(props.value)) || null;
    const formattedOld = former_numbers?.length > 1
        && former_numbers?.[0]?.number && parseNumber(former_numbers[0].number) || null;

    return <div className={`${style.car_number_} ${formattedOld?.number ? style.with_old_number : ''}`}>
        <div className={style.car_number_current}>
            <Copy text={number}
                  externalTooltipId={props.externalTooltipId}
                  className={style.copy_value}
                  internalTooltipId={props.externalTooltipId
                      ? undefined
                      : `car_number_${formattedNumber?.number}`
                  }
                  formatter={Formatter.space}>
                {formattedNumber?.number}
            </Copy>
        </div>
        {formattedOld?.number && <div className={style.car_number_old}>{formattedOld.number}</div> || null}
        <div className={style.car_number_region}>{formattedNumber?.region}</div>
        {formattedOld?.region && <div className={style.car_number_region_old}>{formattedOld.region}</div> || null}
    </div>;
};

export default CarNumber;
