import React from 'react';

import Checkbox from '../../../ui/Checkbox';
import Select, { IOptionInfo } from '../../../ui/Select';
import { isObjectEqual } from '../../../utils/isObjectEqual';
import style from '../index.css';
import { IDefaultFilterProps } from '../types';

interface IFilterBaseProps extends IDefaultFilterProps {
    options: IOptionInfo[];
    getOptions: () => IOptionInfo[];
    filter: string;
    title: string;
    isLoading?: boolean;
}

interface IFilterBaseState {
    chosenOptions: IOptionInfo[];
    isChecked: boolean;
}

export class FilterBase extends React.Component<IFilterBaseProps, IFilterBaseState> {
    state: IFilterBaseState = {
        chosenOptions: [],
        isChecked: false,
    };

    componentDidMount() {
        if (this.props.cars) {
            this.props.getOptions();
        }
    }

    componentDidUpdate(prevProps: Readonly<IFilterBaseProps>, prevState: Readonly<IFilterBaseState>) {
        const { setFilter, setActive, filter, cars, getOptions, filterQuery } = this.props;

        if (prevState.isChecked !== this.state.isChecked) {
            if (this.state.isChecked) {
                this.props.getOptions();
            }

            this.setState({ chosenOptions: [] }, () => {
                setFilter({ [filter]: this.state.chosenOptions });
                setActive({ [filter]: this.state.isChecked });
            });
        }

        if (cars && !isObjectEqual(cars, prevProps.cars)) {
            getOptions();
        }

        if (filterQuery !== prevProps.filterQuery) {
            this.setState({ isChecked: false, chosenOptions: [] });
        }
    }

    onCheckboxChange(isChecked) {
        this.setState({ isChecked });

        if (!isChecked) {
            this.props.setFilter({ [this.props.filter]: [] });
        }
    }

    onSelect(chosenOptions) {
        this.setState({ chosenOptions }, () => {
            this.props.setFilter({ [this.props.filter]: chosenOptions });
        });
    }

    render() {
        const { isChecked } = this.state;
        const { options, title, isLoading } = this.props;

        return <div className={style.filter_wrapper}>
            <Checkbox checked={isChecked} onChange={this.onCheckboxChange.bind(this)}/>

            <span>{title}</span>

            {isChecked
                ? <Select multiSelect={true}
                          isLoading={isLoading}
                          initialValues={this.state.chosenOptions}
                          onSelect={this.onSelect.bind(this)}
                          placeholder={''}
                          className={style.select}
                          options={options}/>
                : null
            }
        </div>;
    }
}
