import React from 'react';

import { IInterfaceAdminProviderProps, InterfaceAdminProvider } from '../../../../../decorators/InterfaceAdminProvider';
import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../../constants';
import { Link } from '../../../../ui/Link';
import { named_filters } from '../../../InterfaceAdminConfig/adminConfigKeys';
import { schema } from '../../../InterfaceAdminConfig/NamedFilters/schema';

interface ISaveFilterModalProps extends IInterfaceAdminProviderProps {
    className?: string;
    filterQuery?: string;
    chosenFilter?: Record<string, any>;
}

const settingsKey = `${GVARS_INTERFACE_ADMIN_PREFIX}.${named_filters}`;

@InterfaceAdminProvider()
export class SaveFilterModal extends React.Component<ISaveFilterModalProps> {
    onSaveFilter(): void {
        const { filterQuery, editData, getDataByKey } = this.props;

        getDataByKey?.(settingsKey, schema);
        editData && editData(filterQuery ? { filter: filterQuery } : {});
    }

    onEditFilter(): void {
        const { filterQuery, editData, getDataByKey, chosenFilter, setIsDataChanged } = this.props;

        getDataByKey?.(settingsKey, schema);
        setIsDataChanged && setIsDataChanged(chosenFilter?.filter !== filterQuery);
        editData && editData(chosenFilter ? { ...chosenFilter, filter: filterQuery } : {});
    }

    render() {
        const { className, filterQuery, chosenFilter } = this.props;

        return (
            <div className={className}>
                {chosenFilter && filterQuery
                    && <Link onClick={this.onEditFilter.bind(this)}>
                        Обновить фильтр
                    </Link>}
                {filterQuery && <Link onClick={this.onSaveFilter.bind(this)}>
                    Сохранить фильтр
                </Link>}
            </div>
        );
    }
}
