import * as React from 'react';
import { useState } from 'react';

import { GetFilterTagRulesDesc } from '../../../constants';
import { Button, ButtonTypes } from '../../../ui/Button';
import { RadioButtonGroup } from '../../../ui/Button/RadioButtonGroup';
import Checkbox from '../../../ui/Checkbox';
import { Window } from '../../../ui/FullModal';
import TextArea from '../../../ui/TextArea';
import { Copy } from '../../Copy';
import { FiltersModal } from '../../InterfaceAdminConfig/NamedFilters/FiltersModal/component';
import { LogicOperator } from '../types';
import * as style from './index.css';
import { SaveFilterModal } from './SaveFilterModal/component';

interface IFilterQueryProps {
    filterQuery: string;
    onLogicOperatorChange: () => void;
    currentLogicOperator: string;
    changeTextarea: (filterQuery: string) => void;
    downloadClick: () => void;
    toMapClick: () => void;
    clearClick: () => void;
    cars: any;
    filterByPoly: boolean;
    changeCheckBox: () => void;
    attachTag: () => void;
    groupHandler: () => void;
    disable: boolean;
}

export const FilterQuery = React.memo((props: IFilterQueryProps) => {
    const {
        filterQuery,
        onLogicOperatorChange,
        currentLogicOperator,
        changeTextarea,
        cars,
        clearClick,
        downloadClick,
        toMapClick,
        filterByPoly,
        changeCheckBox,
        attachTag,
        groupHandler,
        disable,
    } = props;

    const radioButtonGroup =
        [
            { item: `И (${LogicOperator.AND})`, value: LogicOperator.AND },
            { item: `ИЛИ (${LogicOperator.OR})`, value: LogicOperator.OR },
        ];

    const [isLegendOpened, openLegend] = useState<boolean>(false);
    const [chosenFilter, setChosenFilter] = useState<Record<string, any>>();

    function onChooseFilter(selectedFilter: string) {
        changeTextarea(selectedFilter);
    }

    return <div className={style.filter_query}>
        <SaveFilterModal className={style.link} filterQuery={filterQuery} chosenFilter={chosenFilter}/>
        <TextArea placeholder={'Фильтр'} value={filterQuery} onChange={changeTextarea} hidePlaceholder={true}/>
        <div className={style.buttons}>
            <div className={style.buttons_group}>
                <RadioButtonGroup items={radioButtonGroup}
                                  active={currentLogicOperator}
                                  onChange={onLogicOperatorChange}/>

                <Button basic={true}
                        colorType={ButtonTypes.positive}
                        onClick={openLegend.bind(null, true)}
                        className={style.legend_btn}>
                    Легенда
                </Button>
                <FiltersModal className={style.legend_btn}
                              onChooseFilter={onChooseFilter}
                              setChosenFilter={setChosenFilter}/>
            </div>

            {cars.length
                ? <>
                    <div className={style.poly}>
                        <Copy className={style.copy}
                              internalTooltipId={'copy_link'}
                              text={`${location.origin}/#/cars?tags_filter=${filterQuery}`}>
                            <Button className={style.button}
                                    basic>
                                Поделиться ссылкой
                            </Button>
                        </Copy>
                        <Button className={style.button}
                                onClick={downloadClick.bind(null)}
                                colorType={ButtonTypes.warning}>XLSX</Button>
                        <Button className={style.button}
                                onClick={toMapClick.bind(null, filterQuery)}
                                colorType={ButtonTypes.positive}>На карту</Button>
                        <Button className={style.button}
                                onClick={clearClick.bind(null)}
                                colorType={ButtonTypes.positive}
                                basic>Очистить</Button>
                        <div className={style.checkbox}>
                            Полигон&nbsp;
                            <Checkbox checked={filterByPoly}
                                      onChange={changeCheckBox.bind(null)}/>
                        </div>
                        <Button className={style.button}
                                disabled={disable}
                                colorType={ButtonTypes.warning}
                                onClick={attachTag.bind(null)}>
                            + Тег
                        </Button>
                        <Button className={style.button}
                                disabled={disable}
                                onClick={groupHandler.bind(null)}>
                            Пакет
                        </Button>
                    </div>
                </>
                : null
            }

            {isLegendOpened
                ? <Window onClose={openLegend.bind(null, false)}
                          title={'Правила фильтрации тегов'}>
                    {GetFilterTagRulesDesc(style.tags_desc)}
                </Window>
                : null
            }
        </div>
    </div>;
});
