import React, { useEffect, useState } from 'react';

import { IOptionInfo } from '../../../ui/Select';
import { FilterBase } from '../FilterBase/component';
import { CAR_FILTERS, IDefaultFilterProps } from '../types';

type IGeotagFiltersProps = IDefaultFilterProps

export const GeotagFilters = React.memo((props: IGeotagFiltersProps) => {
    const [options, setOptions] = useState<IOptionInfo[]>([]);

    useEffect(() => {
        getOptions();
    }, [props.filterQuery]);

    function getOptions() {
        const areas = new Set();

        props.cars?.forEach(car => {
            if (car.location?.areas) {
                car.location.areas.forEach(area => areas.add(area.id));
            }
        });

        const options = Array.from(areas)?.map(el => {
            return { value: el };
        });

        setOptions(options);
    }

    return <FilterBase filter={CAR_FILTERS.geotag}
                       title={'Фильтр по геотегу'}
                       options={options}
                       getOptions={getOptions.bind(null)}
                       {...props}/>;
});
