import * as React from 'react';

import { EMPTY_DATA } from '../../../constants';
import { Button } from '../../../ui/Button';
import { Confirm, Window } from '../../../ui/FullModal';
import { Link } from '../../../ui/Link';
import { Request2 } from '../../../utils/request';
import { TagActions } from '../../CarCard/CarTagsView/types';
import QueryScheduler, { COUNT_FIRST, IProgressData } from '../../QueryScheduler/QueryScheduler';
import { SimpleError } from '../../SimpleError';
import { CARS_FILTER_REQUESTS, REQUESTS } from '../request';

interface IGroupModalProps {
    cars: any;
    isWorking: boolean;
    onClose: () => void;
}

interface IGroupModalState {
    progress: string;
    success: any[];
    results: any;
    count: number;
    showConfirmIsOpen: boolean;
    accept: () => void | null;
    isWorking: boolean;
    question: string;
    process: string;
    errors: any[];
}

enum TAG_PERFORMER {
    WITH_PERFORMER= 'with_performer',
    WITHOUT_PERFORMER = 'without_performer',
}

export class GroupModal extends React.Component<IGroupModalProps, IGroupModalState> {
    state: any = {
        progress: '',
        success: [],
        results: {},
        count: 0,
        showConfirmIsOpen: false,
        accept: null,
        isWorking: false,
        question: '',
        process: '',
        errors: [],
    };
    request = new Request2({ requestConfigs: CARS_FILTER_REQUESTS });

    [key: string]: any;

    componentDidMount() {
        this.getTags(this.props.cars);
    }

    getTags(cars: any[]) {
        const queue = cars.map((car) => {
            return this.request.exec.bind(this.request, REQUESTS.GET_CAR_TAG_LIST, {
                queryParams: {
                    car_id: car?.id,
                },
            });
        });

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: this.onProgress.bind(this),
            onSuccess: this.onSuccess.bind(this),
        });
        qs.run();
    }

    onProgress(data: IProgressData) {
        const progress = data.failed.length
            ? `${data.success.length}(${data.failed.length})/${data.queue.length}`
            : `${data.success.length}/${data.queue.length}`;
        this.setState({ progress: 'Загрузка тегов по машинам... ' + progress });
    }

    onSuccess(data: IProgressData) {
        const { success = [] } = data;
        let count = 0;
        const results = success.reduce((prev: any, cur: any) => {
            const { records = [] } = cur;
            records.forEach((item: any) => {
                if (!prev.hasOwnProperty(item.tag)) {
                    prev[item.tag] = {
                        with_performer: [],
                        without_performer: [],
                    };
                }

                if (item.performer) {
                    prev[item.tag].with_performer.push({
                        user_id: item.performer,
                        tag_id: item.tag_id,
                    });
                } else {
                    prev[item.tag].without_performer.push({ tag_id: item.tag_id });
                }

                count++;
            });

            return prev;
        }, {});
        this.setState({
            success,
            results,
            count,
        });
    }

    [TAG_PERFORMER.WITH_PERFORMER](data: any, action: any) {
        const queue = data.map((tag: any) => {
            const body = action === TagActions.RESET
                ? { drop_tag_ids: tag.tag_id }
                : action === TagActions.DONE ? { tag_id: tag.tag_id } : {};

            return this.request.exec.bind(this.request, REQUESTS.FINISH_PERFORM, {
                body,
                headers: {
                    UserIdDelegation: tag.user_id,
                },
            });
        });
        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: this.onProgressTag.bind(this),
            onSuccess: this.onSuccessTag.bind(this),
        });
        qs.run();
    }

    [TAG_PERFORMER.WITHOUT_PERFORMER](data: any) {
        const queue = data.map((tag: any) => this.request.exec.bind(this.request, REQUESTS.DELETE_CAR_TAG, {
            queryParams: {
                tag_id: tag.tag_id,
            },
        }));

        const qs = new QueryScheduler({
            queue,
            limit: COUNT_FIRST,
            onProgress: this.onProgressTag.bind(this),
            onSuccess: this.onSuccessTag.bind(this),
        });
        qs.run();
    }

    onProgressTag(data: IProgressData) {
        const progress = data.failed.length
            ? `${data.success.length}(${data.failed.length})/${data.queue.length}`
            : `${data.success.length}/${data.queue.length}`;
        this.setState({ process: 'Обработка автомобилей... ' + progress });
    }

    onSuccessTag(data: IProgressData) {
        this.setState({
            process: this.state.process + ' закончена!',
            errors: data.failed,
        });
    }

    handle(tag: string, type: string, action: any) {
        let question = 'Снять c автомобилей тег';
        if (type === TAG_PERFORMER.WITH_PERFORMER) {
            if (action === TagActions.RESET) {
                question = 'Сбросить исполнителя с тега';
            }

            if (action === TagActions.DONE) {
                question = 'Выполнить тег ';
            }
        }

        this.setState({
            showConfirmIsOpen: true,
            question: `${question} ${tag}`,
            accept: () => {
                this.setState({
                    showConfirmIsOpen: false,
                    process: 'Выполнение операций...',
                }, () => {
                    this[type](this.state.results[tag][type], action);
                });
            },
        });
    }

    onCloseConfirm() {
        this.setState({
            showConfirmIsOpen: false,
        });
    }

    render() {
        const renderItem = (item: any, type: string, action: any) => {
            return item[1][type].length
                && <Link onClick={this.handle.bind(this, item[0], type, action)}>
                    {item[1][type].length}
                </Link> || EMPTY_DATA;
        };

        return <Window onClose={this.props.onClose}
                       title={'Пакетная обработка автомобилей'}>
            <div>
                <div>{this.state.progress}</div>
                <div>
                    {
                        this.state.success.length
                        && <div>Получено <b>{this.state.count}</b> тег(а/ов) по <b>{this.state.success.length}</b> авто
                        </div>
                        || ''
                    }
                </div>
                <div>
                    {this.state.count
                    && <table>
                        <thead>
                            <tr>
                                <th>тег</th>
                                <th>удалить<br/>тег</th>
                                <th>сбросить<br/>тег</th>
                                <th>выполнить<br/>тег</th>
                            </tr>
                        </thead>
                        <tbody>
                            {
                                Object.entries(this.state.results)
                                    .map((item: any, index: number) => {
                                        return <tr key={index}>
                                            <td>{item[0]}</td>
                                            <td>
                                                {renderItem(item, TAG_PERFORMER.WITHOUT_PERFORMER, null)}
                                            </td>
                                            <td>
                                                {renderItem(item, TAG_PERFORMER.WITH_PERFORMER, TagActions.RESET)}
                                            </td>
                                            <td>
                                                {renderItem(item, TAG_PERFORMER.WITH_PERFORMER, TagActions.DONE)}
                                            </td>
                                        </tr>;
                                    })
                            }
                        </tbody>
                    </table> || ''
                    }
                </div>
                <div>
                    {
                        this.state.process
                        && <div>
                            {this.state.process}
                        </div>
                    }
                    {this.state.errors.map((error, index) => {
                        return <SimpleError key={`error-${index}`}
                                            error={error.error}
                                            data={{ label: error.data.toString() }}/>;
                    })}
                </div>
                <div>
                    <Button isLoading={this.props.isWorking}
                            onClick={this.props.onClose.bind(this)}>Закрыть</Button>
                </div>
                {
                    this.state.showConfirmIsOpen
                    && <Confirm accept={this.state.accept.bind(this)}
                                onClose={this.onCloseConfirm.bind(this)}
                                isWorking={this.state.isWorking}
                                question={this.state.question}
                                error={null}/>
                }
            </div>
        </Window>;
    }
}
