import React, { useEffect, useState } from 'react';

import { IOptionInfo } from '../../../ui/Select';
import { FilterBase } from '../FilterBase/component';
import { CAR_FILTERS, ICarOffer, IDefaultFilterProps } from '../types';

interface IOfferFiltersProps extends IDefaultFilterProps {
    offers: ICarOffer[];
}

export const OfferFilters = React.memo((props: IOfferFiltersProps) => {
    const [options, setOptions] = useState<IOptionInfo[]>([]);

    useEffect(() => {
        getOptions();
    }, [props.filterQuery]);

    function getOptions() {
        const optionsMap = {};

        props.offers?.forEach(offer => {
            offer.name
                ? optionsMap[offer.name] = { value: offer.name, description: 'Тариф' }
                : null;
            offer.group_name
                ? optionsMap[offer.group_name] = { value: offer.group_name, description: 'Группа тарифов' }
                : null;
        });

        setOptions(Object.values(optionsMap));
    }

    return <FilterBase filter={CAR_FILTERS.offer}
                       title={'Фильтр по тарифу'}
                       options={options}
                       getOptions={getOptions.bind(null)}
                       {...props}/>;
});
