import * as React from 'react';
import { useEffect, useState } from 'react';

import { IOptionInfo } from '../../../ui/Select';
import { FilterBase } from '../FilterBase/component';
import { CAR_FILTERS, IDefaultFilterProps } from '../types';

interface ITagCommentsProps extends IDefaultFilterProps {
    tagsArray: any[];
}

export const TagComments = React.memo((props: ITagCommentsProps) => {
    const [options, setOptions] = useState<IOptionInfo[]>([]);

    useEffect(() => {
        getOptions();
    }, [props.filterQuery]);

    function getOptions() {
        const { tagsArray, filterQuery } = props;
        const tags = parseFilterQuery(filterQuery);

        const options = tagsArray.reduce((acc, tag) => {
            if (tag.name && tags.includes(tag.name)) {
                acc.push({
                    value: tag.name,
                    description: tag?.description?.display_name ?? tag.name,
                });
            }

            return acc;
        }, []);

        setOptions(options);
    }

    function parseFilterQuery(filterQuery) {
        const splitRegex = /[*,\s]/g;
        const tags = filterQuery.split(splitRegex);

        if (tags[tags.length - 1] === '') {
            tags.pop();
        }

        return tags;
    }

    return <FilterBase filter={CAR_FILTERS.tag}
                       title={'Комментарии к тегу'}
                       options={options}
                       getOptions={getOptions.bind(null)}
                       {...props}/>;
});
