import React, { useEffect, useState } from 'react';

import { IOptionInfo } from '../../../ui/Select';
import { Request2 } from '../../../utils/request';
import { FilterBase } from '../FilterBase/component';
import { CARS_FILTER_REQUESTS, REQUESTS } from '../request';
import { CAR_FILTERS, IDefaultFilterProps } from '../types';

type IWalletFiltersProps = IDefaultFilterProps

export const WalletFilters = React.memo((props: IWalletFiltersProps) => {
    const [options, setOptions] = useState<IOptionInfo[]>([]);
    const [isLoading, setLoading] = useState<boolean>(false);

    useEffect(() => {
        getOptions();
    }, [props.filterQuery]);

    function getOptions() {
        const walletsIds: number[] = getWalletIds();
        let options: IOptionInfo[] = [];

        if (walletsIds.length) {
            setLoading(true);

            const request = new Request2({ requestConfigs: CARS_FILTER_REQUESTS });

            request.exec(REQUESTS.GET_ACCOUNTS, {
                queryParams: { account_id: walletsIds.join() },
            })
                .then(response => {
                    options = walletsIds.map(id => {
                        const walletData = response?.accounts?.find(el => el.id === id) || {};
                        const text = walletData.comment || walletData.details?.company || id;

                        return { value: id, text };
                    });

                    setOptions(options);
                    setLoading(false);
                })

                .catch(() => {
                    const options = walletsIds.map(el => {
                        return { value: el };
                    });

                    setOptions(options);
                    setLoading(false);
                });

        }

        setOptions(options);
    }

    function getWalletIds() {
        const walletsIds: number[] = [];

        props.cars?.forEach(car => {
            const hasParentIds: any = car.tags?.filter((tag: any) => tag.parent_id) ?? [];

            hasParentIds?.forEach(item => {
                if (!walletsIds.includes(item.parent_id)) {
                    walletsIds.push(item.parent_id);
                }
            });
        });

        return walletsIds;
    }

    return <FilterBase filter={CAR_FILTERS.wallet}
                       title={'Фильтр по кошелькам'}
                       options={options}
                       getOptions={getOptions.bind(null)}
                       isLoading={isLoading}
                       {...props}/>;
});
