import { IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export const REQUESTS = {
    GET_CAR_INFO: 'GET_CAR_INFO',
    GET_CARS: 'GET_CARS',
    FINISH_PERFORM: 'FINISH_PERFORM',
    DELETE_CAR_TAG: 'DELETE_CAR_TAG',
    GET_CAR_TAG_LIST: 'GET_CAR_TAG_LIST',
    CAR_TAG_PROPOSE: 'CAR_TAG_PROPOSE',
    ATTACH_CAR_TAG: 'ATTACH_CAR_TAG',
    GET_TAGS: 'GET_TAGS',
    GET_ACCOUNTS: 'GET_ACCOUNTS',
};

export const CARS_FILTER_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_CARS]: {
        api: 'car/list',
        cgiObj: {
            sensors: null,
            traits: null,
            antitraits: null,
            tags_filter: null,
        },
    },
    [REQUESTS.FINISH_PERFORM]: {
        api: 'car/tag/perform/finish',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.DELETE_CAR_TAG]: {
        api: 'car/tag/remove',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.GET_CAR_TAG_LIST]: {
        api: 'car/tag/list',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.CAR_TAG_PROPOSE]: {
        method: REQUEST_METHOD.POST,
        api: 'car/tags/propositions/propose',
        cgiObj: {
            object_id: null,
            comment: null,
        },
    },
    [REQUESTS.ATTACH_CAR_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'car/tag/add',
    },
    [REQUESTS.GET_TAGS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.GET_ACCOUNTS]: {
        api: 'billing/accounts',
        cgiObj: {
            account_id: null,
        },
    },
};
