import { ICar } from '../../../types';

export enum LogicOperator {
    AND = '*',
    OR = ',',
}

export enum CAR_FILTERS {
    offer = 'offer',
    wallet = 'wallet',
    tag = 'tag',
    geotag = 'geotag',
}

export interface ICarTag {
    name: string;
    cars_count_zero: number;
    description: {
        name: string;
        comment?: string;
        default_priority?: string;
        index: number;
        tag_flow_priority: number;
        tag_flow: string;
        display_name: string;
    };
    cars_count: number;
    cars_count_prior: number;
    parent_id?: string;
}

export interface ICarOffer {
    cars_count: number;
    group_name: string;
    id: string;
    name: string;
}

export type FilterItem<T> = {
    [key in CAR_FILTERS]?: T
};
export type CarFilters<T> = {
    [key in CAR_FILTERS]: T
}

export interface IDefaultFilterProps {
    cars: ICar[];
    filterQuery: string;
    setFilter: (filter: FilterItem<string[]>) => void;
    setActive: (filter: FilterItem<boolean>) => void;
}
