import { connect } from 'react-redux';
import { withRouter } from 'react-router';

import { getMyChats } from '../../reducers/chatReducer/getters';
import { setChats, setChatsLoading } from '../../reducers/chatReducer/setters';
import { IStore } from '../App/store';
import { _CHATS } from '../ChatsCommon/types';
import { ChatNotify } from './component';

export interface INotifyMapStateToProps extends IStore {
    myChats: any;
}

export const mapStateToProps = (store: IStore): INotifyMapStateToProps => {
    const myChats = getMyChats(store);

    return {
        AdminUser: store.AdminUser,
        myChats,
    };
};

export function mapDispatchToProps(dispatch: any) {
    return {
        setChats: (data, error) => {
            dispatch(setChats(data, error));
        },
        setChatsLoading: (payload: { chatType: _CHATS; state: boolean }) => {
            dispatch(setChatsLoading(payload));
        },
    };
}

export default withRouter<any, any>(connect<IStore, {}, {}>(mapStateToProps, mapDispatchToProps)(ChatNotify));
