import React from 'react';

import { EMPTY_DATA } from '../../../constants';
import { UserInfoHandler } from '../../../models/user';
import { ChatMessageItem, OUTGOING_MESSAGE_TYPES } from './ChatMessageItem';
import { ClassificationCommentItem } from './ClassificationCommentItem';
import { DamagesPhotosView } from './DamagesPhotos';
import { LeasingSupportItem } from './LeasingSupportItem';
import { LongtermWidget } from './LongtermWidget';

interface IWindowContentProps {
    selectedChatItem: any;
    classification_comment: any;
    users: any;
    messages: any[];
    longtermData: any;
    damagesSessionId: string | null;
    leasingSupportData?: {
        alarm_raise_url: string;
        at: number;
        external_photo_url?: string;
        external_video_url?: string;
        photo_url?: string;
        type: string;
        video_url?: string;
    };
    openEvolutionModal: (isOpen: boolean) => void;
}

export const ChatWindowContent = React.memo((props: IWindowContentProps) => {
    const classificationComments = props.classification_comment?.sort((a, b) => {
        return a.timestamp - b.timestamp;
    }) || [];
    const messages = props.messages || [];

    if (props.longtermData && !messages.some(el => {
        return el.type === OUTGOING_MESSAGE_TYPES.longterm_target_point;
    })) {
        const deliveryLocation = props.longtermData?.Offer?.LongTermOffer?.DeliveryLocation;
        const coordinates = [deliveryLocation?.XHP, deliveryLocation?.YHP];

        messages?.splice(1, 0, {
            author: 'robot-frontend (сгенерировано на фронте)',
            type: OUTGOING_MESSAGE_TYPES.longterm_target_point,
            timestamp: messages?.[0]?.timestamp || 0,
            text: `Точка подгона авто: ${props.longtermData?.Offer?.LongTermOffer?.DeliveryLocationName ?? ''}`,
            src: getStaticMapLink(coordinates[0], coordinates[1]),
        });
    }

    const actualPhotosId = props.selectedChatItem?.tag_data?.links ?? [];

    return <div>
        {props.longtermData
            ? <LongtermWidget selectedChatItem={props.selectedChatItem}
                              openEvolutionModal={props.openEvolutionModal.bind(null)}
                              longtermData={props.longtermData}/>
            : null
        }

        {messages?.map((item, index) => {
            return !(props.leasingSupportData && index === 1)
                && <ChatMessageItem users={props.users} item={item} key={item.id}/>;
        })
        }

        {props.damagesSessionId
            ? <DamagesPhotosView sessionId={props.damagesSessionId} actualPhotosId={actualPhotosId}/>
            : null
        }

        {props.leasingSupportData
            ? <LeasingSupportItem data={props.leasingSupportData} chatId={props.selectedChatItem?.id}/>
            : null}

        {classificationComments?.map((el, ind) => {
            const authorData = props.users?.[el.operator_id] ?? {};
            const author = UserInfoHandler.getPrintName.call(authorData) || EMPTY_DATA;
            const category = el?.category?.meta?.label || EMPTY_DATA;

            return el.comment
                ? <ClassificationCommentItem key={ind} author={author} category={category} el={el}/>
                : null;
        })
        }
    </div>;
});

function getStaticMapLink(lon, lat) {
    return `https://static-maps.yandex.ru/1.x/?l=map&pt=${lon},${lat},pm2rdm&z=13&size=370,170`;
}
