import React, { useState } from 'react';
import { RouteComponentProps } from 'react-router';
import { withRouter } from 'react-router-dom';

import HistoryIcon from '../../../../svg-components/history.component.svg';
import LinkIcon from '../../../../svg-components/link.component.svg';
import { ClassificationType } from '../../../../types';
import ChatHistoryView from '../../Chats/ChatHistoryView';
import { ChatHeaderClassification, IClassificationParams } from '../../ChatsCommon/ChatHeaderClassification';
import { getHrefTagId } from '../../ChatsCommon/chatUtils';
import { chatLink } from '../../ChatsCommon/helpers';
import { NChats } from '../../ChatsCommon/types';
import { Copy } from '../../Copy';
import Spin from '../../Spin';
import style from '../index.css';
import ICategory = NChats.ICategory;

interface IChatWindowHeaderProps extends RouteComponentProps {
    title: string;
    classificationData: ICategory[];
    commentsIsLoading: boolean;
    selectedChatItem: any;
    classificationParams: IClassificationParams;
    getClassification: (tag_id: string) => void;
}

const ChatWindowHeader = (props: IChatWindowHeaderProps) => {
    const {
        title,
        classificationData,
        commentsIsLoading,
        selectedChatItem,
        classificationParams,
        getClassification,
    } = props;
    const [openChatHistory, setOpenChatHistory] = useState<boolean>(false);
    const tag_id = selectedChatItem?.tag_id || selectedChatItem?.tag_data?.tag_id || getHrefTagId(props.location);
    const tag = selectedChatItem?.tag_data?.tag;

    return <div className={style.title}>
        <div>
            <span className={style.title_name}>{title}</span>
            <ChatHeaderClassification classificationData={classificationData}
                                      type={ClassificationType.call}
                                      keyword={tag}
                                      classificationParams={classificationParams}
                                      getClassification={getClassification.bind(null)}/>
        </div>
        <div className={style.header_controls}>
            {
                commentsIsLoading
                    ? <Spin size={'x'}/>
                    : null
            }
            <HistoryIcon className={style.header_button_item}
                         onClick={setOpenChatHistory.bind(null, true)}/>
            <Copy text={chatLink(selectedChatItem, true, tag_id)} className={style.copy}>
                <LinkIcon className={style.share_chat}/>
            </Copy>
        </div>
        {openChatHistory
            ? <ChatHistoryView tag_id={tag_id}
                               user_id={props.selectedChatItem?.originator}
                               chat_id={props.selectedChatItem?.topic_link}
                               linked_tag_id={props.selectedChatItem?.tag_data?.linked_tag_id}
                               onClose={setOpenChatHistory.bind(null, false)}/>
            : null
        }

    </div>;
};

export default withRouter<any, any>((ChatWindowHeader));
