import React from 'react';

import { ONE_SECOND } from '../../../constants';
import FormatDate from '../../../ui/FormatDate';
import * as style from '../index.css';

interface IClassificationCommentItemProps {
    category: any;
    author: string;
    el: any;
}

export const ClassificationCommentItem = React.memo((props: IClassificationCommentItemProps) => {
    const { category, author, el } = props;

    return <div className={style.classification_comment}>
        <div className={style.classification_title}><i>Комментарий классификации <b>{category}</b></i></div>
        <div className={style.classification_author}>{author}</div>
        <div>{el.comment}</div>
        <FormatDate value={el.timestamp * ONE_SECOND} className={style.classification_date}/>
    </div>;
});
