import React from 'react';

import { Dict } from '../../../../../types';
import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import { Collapse2 } from '../../../../ui/Collapse2';
import FormatDate from '../../../../ui/FormatDate';
import { IsChecked } from '../../../../ui/IsChecked';
import { Link } from '../../../../ui/Link';
import Img from '../../../Img';
import { PictureGallery } from '../../../PictureGallery';
import { ChatsOutgoingContext } from '../../context';
import { formatLink, getArea, getDamageLevel, getDescription, reduceDups, Verdicts } from './constants';
import style from './index.css';

interface IDamagePhotoItem {
    photo: any;
    onPhotoClick: () => void;
    configs: Dict<any>;
}

export const DamagePhotoItem = (props: IDamagePhotoItem) => {
    const { photo, onPhotoClick, configs } = props;
    const context: any = React.useContext(ChatsOutgoingContext);
    const isSelected = context?.selectedDamagePhotos?.some(el => el.image_id === photo.image_id);
    const onSelectItem = context.selectDamagePhoto.bind(null, photo);
    const [selectedDupsPhotoIndex, selectPhoto] = React.useState(null);

    const photoClick = (e) => {
        e?.stopPropagation();
        onPhotoClick();
    };

    const dupsWithLinks = photo?.dups?.reduce(reduceDups, []);

    const showDubsGallery = (selectedDupsPhotoIndex, e) => {
        e?.stopPropagation();
        selectPhoto(selectedDupsPhotoIndex);
    };

    const dupsImages = photo.dups?.map(img => ({ src: img.url, link: img.url }));

    return <div className={`${style.damage_item} ${isSelected ? style.selected : ''}`} onClick={onSelectItem}>
        <div className={`${style.select}`}/>
        <div className={style.damage_item_photo} onClick={photoClick}>
            <Img src={photo.preview_url || photo.url}/>
        </div>
        <div className={style.damage_item_data}>
            <Tables photo={photo} configs={configs}/>
            {
                photo?.dups?.length ? <>
                    {
                        dupsWithLinks.length && <>
                            <h4>Таски из дублей</h4>
                            <table>
                                <SupportVerdictTH/>
                                <tbody>
                                    {
                                        dupsWithLinks?.map((el, index) => {
                                            return <SupportVerdictTR el={el} key={index}/>;
                                        })
                                    }
                                </tbody>
                            </table>
                        </> || null
                    }

                    <Collapse2 expandText={'Посмотреть на дубли'}
                               initialExpanded={false}
                               title={``}
                               headerClassname={style.collapse_header}>
                        {
                            photo.dups?.map((el, index) => {
                                return <div key={index}>
                                    <h4>Дубль - {index + 1}</h4>
                                    <div className={`${style.dups_line}`}>
                                        <div className={`${style.dups_line_item}`}
                                             onClick={showDubsGallery.bind(null, index)}>
                                            <Img src={el.preview_url || el.url}
                                                 className={`${style.dups_line_item_photo}`}/>
                                        </div>
                                        <div className={`${style.dups_line_item}`}>
                                            <Tables photo={el} configs={configs} key={index}/>
                                        </div>
                                    </div>
                                </div>;
                            })
                        }
                        {
                            selectedDupsPhotoIndex !== null
                            && <PictureGallery onClose={showDubsGallery.bind(null, null)}
                                               pictures={dupsImages}
                                               initialIndex={selectedDupsPhotoIndex || 0}/>
                        }
                    </Collapse2>
                </> : null
            }

        </div>
    </div>;
};

const Tables = (props: { photo; configs }) => {
    const { photo, configs } = props;

    return <>
        <div>
            <h5>ТОЛОКА <FormatDate value={photo.created_at * ONE_SECOND} withSecond/> (id={photo.image_id}). {
                photo?.dups?.length
                    ? <span className={style.dups}>Дублей: <strong>{photo.dups.length}</strong></span>
                    : null
            }</h5>
            {photo.mark_up_list?.length ? <table>
                <thead>
                    <tr>
                        <th>район</th>
                        <th>уровень</th>
                        <th>описание</th>
                        <th>валидность</th>
                        <th>лучшая</th>
                    </tr>
                </thead>
                <tbody>
                    {
                        photo.mark_up_list.map((el, index) => {
                            return <tr key={index}>
                                <td>{el?.area ? getArea(configs, el) : EMPTY_DATA}</td>
                                <td>{el?.damage_level ? getDamageLevel(configs, el) : EMPTY_DATA}</td>
                                <td>{el?.description ? getDescription(configs, el) : EMPTY_DATA}</td>
                                <td>{el?.discarded && <IsChecked checked={el?.discarded}/>}</td>
                                <td>{el?.is_the_best && <IsChecked checked={el?.is_the_best}/>}</td>
                            </tr>;
                        })
                    }
                </tbody>
            </table> : <h5>Нет разметки</h5>}
        </div>
        <div>
            <h5>САППОРТ <FormatDate value={photo?.meta_data?.support_verdicts_timestamp} withSecond/></h5>
            {photo?.meta_data?.support_verdicts?.length ? <table>
                <SupportVerdictTH/>
                <tbody>
                    {
                        photo.meta_data.support_verdicts.map((el, index) => {
                            return <SupportVerdictTR el={el} key={index}/>;
                        })
                    }
                </tbody>
            </table> : <h5>Нет разметки</h5>}
        </div>
    </>;
};

const SupportVerdictTH = () => {
    return <thead>
        <tr>
            <th>вердикт</th>
            <th>ссылка</th>
        </tr>
    </thead>;
};

const SupportVerdictTR = (props) => {
    const { el } = props;

    return <tr>
        <td>{el?.verdict ? Verdicts[el.verdict] : el.verdict || EMPTY_DATA}</td>
        <td><STLink el={el}/></td>
    </tr>;
};

export const STLink = (props) => {
    const { el } = props;

    return el?.st_link ?
        <Link target={'_blank'} href={el.st_link}>{formatLink(el.st_link)}</Link> : null;
};
