import React, { useState } from 'react';

import { Button, ButtonTypes } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import { FormConstructor } from '../../../FormConstructor';
import { controlType } from '../../../FormConstructor/types';
import { Verdicts } from './constants';
import style from './index.css';

const schema = {
    'support_verdicts': {
        'type': controlType.array_types,
        'display_name': 'Вердикты',

        'array_type': {
            verdict: {
                type: controlType.variants,
                display_name: 'Вердикт',
                required: true,
                variants: Object.entries(Verdicts).map(el => {
                    return {
                        text: el[1],
                        value: el[0],
                    };
                }),
            },
            st_link: { type: controlType.string, display_name: 'Ссылка на трекер' },
        },
        'default': [
            {},
        ],
    },
};

export const MarkupPhoto = (props) => {
    const [data, setData] = useState({});
    const [isValid, setIsValid] = useState(false);
    const onChange = (value, isValid) => {
        setData(value);
        setIsValid(isValid);
    };

    const initialData = props.initialData.length === 1 ? props.initialData[0]?.meta_data : { support_verdicts: [{}] };

    return <Window onClose={props.onClose} title={'Разметка фото'} className={style.markup_window} error={props.error}>
        <FormConstructor schema={schema} onChange={onChange} initialData={initialData}/>
        <div className={style.markup_window_control}>
            <Button disabled={!isValid}
                    isLoading={props.isLoading}
                    colorType={ButtonTypes.positive}
                    onClick={props.markup.bind(null, data)}>Разметить</Button>

            <Button disabled={!isValid}
                    isLoading={props.isLoading}
                    colorType={ButtonTypes.negative}
                    onClick={props.markup.bind(null, null)}>Удалить разметку</Button>
        </div>
    </Window>;
};
